/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;

public class DropDB
extends Statement {
    private final Identifier dbName;
    private final boolean exists;

    public DropDB(Identifier catalogName, boolean exists) {
        super(null);
        this.dbName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.exists = exists;
    }

    public DropDB(NodeLocation location, Identifier catalogName, boolean exists) {
        super(Objects.requireNonNull(location, "location is null"));
        this.dbName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.exists = exists;
    }

    public Identifier getDbName() {
        return this.dbName;
    }

    public boolean isExists() {
        return this.exists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDropDB(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DropDB o = (DropDB)obj;
        return Objects.equals(this.dbName, o.dbName) && this.exists == o.exists;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.dbName, this.exists);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("catalogName", (Object)this.dbName).add("exists", this.exists).toString();
    }
}

