/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.confignode.rpc.thrift.TTableInfo;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.Binary;

public class ShowTablesTask
implements IConfigTask {
    private final String database;
    private final Predicate<String> checkCanShowTable;

    public ShowTablesTask(String database, Predicate<String> checkCanShowTable) {
        this.database = database;
        this.checkCanShowTable = checkCanShowTable;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showTables(this.database, this.checkCanShowTable, false);
    }

    public static void buildTsBlock(List<TTableInfo> tableInfoList, SettableFuture<ConfigTaskResult> future, Predicate<String> checkCanShowTable) {
        List outputDataTypes = ColumnHeaderConstant.showTablesColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        tableInfoList.stream().filter(t -> checkCanShowTable.test(t.getTableName())).forEach(tableInfo -> {
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.getColumnBuilder(0).writeBinary(new Binary(tableInfo.getTableName(), TSFileConfig.STRING_CHARSET));
            builder.getColumnBuilder(1).writeBinary(new Binary(tableInfo.getTTL(), TSFileConfig.STRING_CHARSET));
            builder.declarePosition();
        });
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowTablesHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

