/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ai;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.model.ModelType;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class ShowModelsTask
implements IConfigTask {
    private final String modelName;
    private static final String INPUT_SHAPE = "inputShape:";
    private static final String OUTPUT_SHAPE = "outputShape:";
    private static final String INPUT_DATA_TYPE = "inputDataType:";
    private static final String OUTPUT_DATA_TYPE = "outputDataType:";
    private static final String EMPTY_STRING = "";

    public ShowModelsTask(String modelName) {
        this.modelName = modelName;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showModels(this.modelName);
    }

    public static void buildTsBlock(List<ByteBuffer> modelInfoList, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.showModelsColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        for (ByteBuffer modelInfo : modelInfoList) {
            String config;
            String note;
            String modelId = ReadWriteIOUtils.readString((ByteBuffer)modelInfo);
            String modelType = ReadWriteIOUtils.readString((ByteBuffer)modelInfo);
            String state = ReadWriteIOUtils.readString((ByteBuffer)modelInfo);
            if (Objects.equals(modelType, ModelType.USER_DEFINED.toString())) {
                String inputShape = ReadWriteIOUtils.readString((ByteBuffer)modelInfo);
                String outputShape = ReadWriteIOUtils.readString((ByteBuffer)modelInfo);
                String inputTypes = ReadWriteIOUtils.readString((ByteBuffer)modelInfo);
                String outputTypes = ReadWriteIOUtils.readString((ByteBuffer)modelInfo);
                note = ReadWriteIOUtils.readString((ByteBuffer)modelInfo);
                config = INPUT_SHAPE + inputShape + OUTPUT_SHAPE + outputShape + INPUT_DATA_TYPE + inputTypes + OUTPUT_DATA_TYPE + outputTypes;
            } else {
                config = EMPTY_STRING;
                note = "Built-in model in IoTDB";
            }
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.getColumnBuilder(0).writeBinary(BytesUtils.valueOf((String)modelId));
            builder.getColumnBuilder(1).writeBinary(BytesUtils.valueOf((String)modelType));
            builder.getColumnBuilder(2).writeBinary(BytesUtils.valueOf((String)state));
            builder.getColumnBuilder(3).writeBinary(BytesUtils.valueOf((String)config));
            if (note != null) {
                builder.getColumnBuilder(4).writeBinary(BytesUtils.valueOf((String)note));
            } else {
                builder.getColumnBuilder(4).writeBinary(BytesUtils.valueOf((String)EMPTY_STRING));
            }
            builder.declarePosition();
        }
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowModelsHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

