/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.terminate;

import java.util.concurrent.CompletableFuture;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TreePattern;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;

public class PipeTerminateEvent
extends EnrichedEvent {
    private final int dataRegionId;

    public PipeTerminateEvent(String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, int dataRegionId) {
        super(pipeName, creationTime, pipeTaskMeta, null, null, null, true, Long.MIN_VALUE, Long.MAX_VALUE);
        this.dataRegionId = dataRegionId;
    }

    public boolean internallyIncreaseResourceReferenceCount(String holderMessage) {
        return true;
    }

    public boolean internallyDecreaseResourceReferenceCount(String holderMessage) {
        return true;
    }

    public ProgressIndex getProgressIndex() {
        return MinimumProgressIndex.INSTANCE;
    }

    public EnrichedEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, TreePattern treePattern, TablePattern tablePattern, String userName, boolean skipIfNoPrivileges, long startTime, long endTime) {
        return new PipeTerminateEvent(pipeName, creationTime, pipeTaskMeta, this.dataRegionId);
    }

    public boolean isGeneratedByPipe() {
        return false;
    }

    public boolean mayEventTimeOverlappedWithTimeRange() {
        return true;
    }

    public boolean mayEventPathsOverlappedWithPattern() {
        return true;
    }

    public void reportProgress() {
        CompletableFuture.runAsync(() -> PipeDataNodeAgent.task().markCompleted(this.pipeName, this.dataRegionId));
    }

    public String toString() {
        return String.format("PipeTerminateEvent{dataRegionId=%s}", this.dataRegionId) + " - " + super.toString();
    }
}

