/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.List;
import org.apache.iotdb.db.utils.datastructure.AlignedTVList;
import org.apache.iotdb.db.utils.datastructure.MemPointIterator;
import org.apache.iotdb.db.utils.datastructure.MergeSortMultiAlignedTVListIterator;
import org.apache.iotdb.db.utils.datastructure.MergeSortMultiTVListIterator;
import org.apache.iotdb.db.utils.datastructure.OrderedMultiAlignedTVListIterator;
import org.apache.iotdb.db.utils.datastructure.OrderedMultiTVListIterator;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.common.TimeRange;

public class MemPointIteratorFactory {
    private MemPointIteratorFactory() {
    }

    private static MemPointIterator single(List<TVList> tvLists) {
        return tvLists.get(0).iterator(null, null, null);
    }

    private static MemPointIterator single(List<TVList> tvLists, List<TimeRange> deletionList) {
        return tvLists.get(0).iterator(deletionList, null, null);
    }

    private static MemPointIterator single(List<TVList> tvLists, List<TimeRange> deletionList, Integer floatPrecision, TSEncoding encoding) {
        return tvLists.get(0).iterator(deletionList, floatPrecision, encoding);
    }

    private static MemPointIterator mergeSort(TSDataType tsDataType, List<TVList> tvLists) {
        return new MergeSortMultiTVListIterator(tsDataType, tvLists, null, null, null);
    }

    private static MemPointIterator mergeSort(TSDataType tsDataType, List<TVList> tvLists, List<TimeRange> deletionList) {
        return new MergeSortMultiTVListIterator(tsDataType, tvLists, deletionList, null, null);
    }

    private static MemPointIterator mergeSort(TSDataType tsDataType, List<TVList> tvLists, List<TimeRange> deletionList, Integer floatPrecision, TSEncoding encoding) {
        return new MergeSortMultiTVListIterator(tsDataType, tvLists, deletionList, floatPrecision, encoding);
    }

    private static MemPointIterator ordered(TSDataType tsDataType, List<TVList> tvLists) {
        return new OrderedMultiTVListIterator(tsDataType, tvLists, null, null, null);
    }

    private static MemPointIterator ordered(TSDataType tsDataType, List<TVList> tvLists, List<TimeRange> deletionList) {
        return new OrderedMultiTVListIterator(tsDataType, tvLists, deletionList, null, null);
    }

    private static MemPointIterator ordered(TSDataType tsDataType, List<TVList> tvLists, List<TimeRange> deletionList, Integer floatPrecision, TSEncoding encoding) {
        return new OrderedMultiTVListIterator(tsDataType, tvLists, deletionList, floatPrecision, encoding);
    }

    private static MemPointIterator single(List<TSDataType> tsDataTypes, List<Integer> columnIndexList, List<AlignedTVList> alignedTvLists, boolean ignoreAllNullRows) {
        return alignedTvLists.get(0).iterator(tsDataTypes, columnIndexList, null, null, null, null, ignoreAllNullRows);
    }

    private static MemPointIterator single(List<TSDataType> tsDataTypes, List<Integer> columnIndexList, List<AlignedTVList> alignedTvLists, List<TimeRange> timeColumnDeletion, List<List<TimeRange>> valueColumnsDeletionList, boolean ignoreAllNullRows) {
        return alignedTvLists.get(0).iterator(tsDataTypes, columnIndexList, timeColumnDeletion, valueColumnsDeletionList, null, null, ignoreAllNullRows);
    }

    private static MemPointIterator single(List<TSDataType> tsDataTypes, List<Integer> columnIndexList, List<AlignedTVList> alignedTvLists, List<TimeRange> timeColumnDeletion, List<List<TimeRange>> valueColumnsDeletionList, Integer floatPrecision, List<TSEncoding> encodingList, boolean ignoreAllNullRows) {
        return alignedTvLists.get(0).iterator(tsDataTypes, columnIndexList, timeColumnDeletion, valueColumnsDeletionList, floatPrecision, encodingList, ignoreAllNullRows);
    }

    private static MemPointIterator mergeSort(List<TSDataType> tsDataTypes, List<Integer> columnIndexList, List<AlignedTVList> alignedTvLists, boolean ignoreAllNullRows) {
        return new MergeSortMultiAlignedTVListIterator(tsDataTypes, columnIndexList, alignedTvLists, null, null, null, null, ignoreAllNullRows);
    }

    private static MemPointIterator mergeSort(List<TSDataType> tsDataTypes, List<Integer> columnIndexList, List<AlignedTVList> alignedTvLists, List<TimeRange> timeColumnDeletion, List<List<TimeRange>> valueColumnsDeletionList, boolean ignoreAllNullRows) {
        return new MergeSortMultiAlignedTVListIterator(tsDataTypes, columnIndexList, alignedTvLists, timeColumnDeletion, valueColumnsDeletionList, null, null, ignoreAllNullRows);
    }

    private static MemPointIterator mergeSort(List<TSDataType> tsDataTypes, List<Integer> columnIndexList, List<AlignedTVList> alignedTvLists, List<TimeRange> timeColumnDeletion, List<List<TimeRange>> valueColumnsDeletionList, Integer floatPrecision, List<TSEncoding> encodingList, boolean ignoreAllNullRows) {
        return new MergeSortMultiAlignedTVListIterator(tsDataTypes, columnIndexList, alignedTvLists, timeColumnDeletion, valueColumnsDeletionList, floatPrecision, encodingList, ignoreAllNullRows);
    }

    private static MemPointIterator ordered(List<TSDataType> tsDataTypes, List<Integer> columnIndexList, List<AlignedTVList> alignedTvLists, boolean ignoreAllNullRows) {
        return new OrderedMultiAlignedTVListIterator(tsDataTypes, columnIndexList, alignedTvLists, null, null, null, null, ignoreAllNullRows);
    }

    private static MemPointIterator ordered(List<TSDataType> tsDataTypes, List<Integer> columnIndexList, List<AlignedTVList> alignedTvLists, List<TimeRange> timeColumnDeletion, List<List<TimeRange>> valueColumnsDeletionList, boolean ignoreAllNullRows) {
        return new OrderedMultiAlignedTVListIterator(tsDataTypes, columnIndexList, alignedTvLists, timeColumnDeletion, valueColumnsDeletionList, null, null, ignoreAllNullRows);
    }

    private static MemPointIterator ordered(List<TSDataType> tsDataTypes, List<Integer> columnIndexList, List<AlignedTVList> alignedTvLists, List<TimeRange> timeColumnDeletion, List<List<TimeRange>> valueColumnsDeletionList, Integer floatPrecision, List<TSEncoding> encodingList, boolean ignoreAllNullRows) {
        return new OrderedMultiAlignedTVListIterator(tsDataTypes, columnIndexList, alignedTvLists, timeColumnDeletion, valueColumnsDeletionList, floatPrecision, encodingList, ignoreAllNullRows);
    }

    public static MemPointIterator create(TSDataType tsDataType, List<TVList> tvLists) {
        if (tvLists.size() == 1) {
            return MemPointIteratorFactory.single(tvLists);
        }
        if (MemPointIteratorFactory.isCompleteOrdered(tvLists)) {
            return MemPointIteratorFactory.ordered(tsDataType, tvLists);
        }
        return MemPointIteratorFactory.mergeSort(tsDataType, tvLists);
    }

    public static MemPointIterator create(TSDataType tsDataType, List<TVList> tvLists, List<TimeRange> deletionList) {
        if (tvLists.size() == 1) {
            return MemPointIteratorFactory.single(tvLists, deletionList);
        }
        if (MemPointIteratorFactory.isCompleteOrdered(tvLists)) {
            return MemPointIteratorFactory.ordered(tsDataType, tvLists, deletionList);
        }
        return MemPointIteratorFactory.mergeSort(tsDataType, tvLists, deletionList);
    }

    public static MemPointIterator create(TSDataType tsDataType, List<TVList> tvLists, List<TimeRange> deletionList, Integer floatPrecision, TSEncoding encoding) {
        if (tvLists.size() == 1) {
            return MemPointIteratorFactory.single(tvLists, deletionList, floatPrecision, encoding);
        }
        if (MemPointIteratorFactory.isCompleteOrdered(tvLists)) {
            return MemPointIteratorFactory.ordered(tsDataType, tvLists, deletionList, floatPrecision, encoding);
        }
        return MemPointIteratorFactory.mergeSort(tsDataType, tvLists, deletionList, floatPrecision, encoding);
    }

    public static MemPointIterator create(List<TSDataType> tsDataTypes, List<Integer> columnIndexList, List<AlignedTVList> alignedTvLists, boolean ignoreAllNullRows) {
        if (alignedTvLists.size() == 1) {
            return MemPointIteratorFactory.single(tsDataTypes, columnIndexList, alignedTvLists, ignoreAllNullRows);
        }
        if (MemPointIteratorFactory.isCompleteOrdered(alignedTvLists)) {
            return MemPointIteratorFactory.ordered(tsDataTypes, columnIndexList, alignedTvLists, ignoreAllNullRows);
        }
        return MemPointIteratorFactory.mergeSort(tsDataTypes, columnIndexList, alignedTvLists, ignoreAllNullRows);
    }

    public static MemPointIterator create(List<TSDataType> tsDataTypes, List<Integer> columnIndexList, List<AlignedTVList> alignedTvLists, List<TimeRange> timeColumnDeletion, List<List<TimeRange>> valueColumnsDeletionList, boolean ignoreAllNullRows) {
        if (alignedTvLists.size() == 1) {
            return MemPointIteratorFactory.single(tsDataTypes, columnIndexList, alignedTvLists, timeColumnDeletion, valueColumnsDeletionList, ignoreAllNullRows);
        }
        if (MemPointIteratorFactory.isCompleteOrdered(alignedTvLists)) {
            return MemPointIteratorFactory.ordered(tsDataTypes, columnIndexList, alignedTvLists, timeColumnDeletion, valueColumnsDeletionList, ignoreAllNullRows);
        }
        return MemPointIteratorFactory.mergeSort(tsDataTypes, columnIndexList, alignedTvLists, timeColumnDeletion, valueColumnsDeletionList, ignoreAllNullRows);
    }

    public static MemPointIterator create(List<TSDataType> tsDataTypes, List<Integer> columnIndexList, List<AlignedTVList> alignedTvLists, List<TimeRange> timeColumnDeletion, List<List<TimeRange>> valueColumnsDeletionList, Integer floatPrecision, List<TSEncoding> encodingList, boolean ignoreAllNullRows) {
        if (alignedTvLists.size() == 1) {
            return MemPointIteratorFactory.single(tsDataTypes, columnIndexList, alignedTvLists, timeColumnDeletion, valueColumnsDeletionList, floatPrecision, encodingList, ignoreAllNullRows);
        }
        if (MemPointIteratorFactory.isCompleteOrdered(alignedTvLists)) {
            return MemPointIteratorFactory.ordered(tsDataTypes, columnIndexList, alignedTvLists, timeColumnDeletion, valueColumnsDeletionList, floatPrecision, encodingList, ignoreAllNullRows);
        }
        return MemPointIteratorFactory.mergeSort(tsDataTypes, columnIndexList, alignedTvLists, timeColumnDeletion, valueColumnsDeletionList, floatPrecision, encodingList, ignoreAllNullRows);
    }

    private static boolean isCompleteOrdered(List<? extends TVList> tvLists) {
        long time = Long.MIN_VALUE;
        for (int i = 0; i < tvLists.size(); ++i) {
            TVList list = tvLists.get(i);
            if (!list.isSorted()) {
                return false;
            }
            if (tvLists.get(i).rowCount() == 0) continue;
            if (i > 0 && list.getTime(0) <= time) {
                return false;
            }
            time = list.getTime(list.rowCount() - 1);
        }
        return true;
    }
}

