/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.AggregationMask;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.TableAccumulator;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.statistics.IntegerStatistics;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.block.column.BinaryColumn;
import org.apache.tsfile.read.common.block.column.BinaryColumnBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class AvgAccumulator
implements TableAccumulator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(AvgAccumulator.class);
    private final TSDataType argumentDataType;
    private long countValue;
    private double sumValue;
    private boolean initResult = false;

    public AvgAccumulator(TSDataType argumentDataType) {
        this.argumentDataType = argumentDataType;
    }

    @Override
    public long getEstimatedSize() {
        return INSTANCE_SIZE;
    }

    @Override
    public TableAccumulator copy() {
        return new AvgAccumulator(this.argumentDataType);
    }

    @Override
    public void addInput(Column[] arguments, AggregationMask mask) {
        Preconditions.checkArgument((arguments.length == 1 ? 1 : 0) != 0, (Object)"argument of Avg should be one column");
        switch (this.argumentDataType) {
            case INT32: {
                this.addIntInput(arguments[0], mask);
                return;
            }
            case INT64: {
                this.addLongInput(arguments[0], mask);
                return;
            }
            case FLOAT: {
                this.addFloatInput(arguments[0], mask);
                return;
            }
            case DOUBLE: {
                this.addDoubleInput(arguments[0], mask);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in aggregation AVG : %s", this.argumentDataType));
    }

    @Override
    public void removeInput(Column[] arguments) {
        Preconditions.checkArgument((arguments.length == 1 ? 1 : 0) != 0, (Object)"argument of Avg should be one column");
        switch (this.argumentDataType) {
            case INT32: {
                this.removeIntInput(arguments[0]);
                return;
            }
            case INT64: {
                this.removeLongInput(arguments[0]);
                return;
            }
            case FLOAT: {
                this.removeFloatInput(arguments[0]);
                return;
            }
            case DOUBLE: {
                this.removeDoubleInput(arguments[0]);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in aggregation AVG : %s", this.argumentDataType));
    }

    @Override
    public void addIntermediate(Column argument) {
        Preconditions.checkArgument((argument instanceof BinaryColumn || argument instanceof RunLengthEncodedColumn && ((RunLengthEncodedColumn)argument).getValue() instanceof BinaryColumn ? 1 : 0) != 0, (Object)"intermediate input and output of Avg should be BinaryColumn");
        for (int i = 0; i < argument.getPositionCount(); ++i) {
            if (argument.isNull(i)) continue;
            this.initResult = true;
            long midCountValue = BytesUtils.bytesToLong((byte[])argument.getBinary(i).getValues(), (int)8);
            double midSumValue = BytesUtils.bytesToDouble((byte[])argument.getBinary(i).getValues(), (int)8);
            this.countValue += midCountValue;
            this.sumValue += midSumValue;
        }
    }

    @Override
    public void evaluateIntermediate(ColumnBuilder columnBuilder) {
        Preconditions.checkArgument((boolean)(columnBuilder instanceof BinaryColumnBuilder), (Object)"intermediate input and output of Avg should be BinaryColumn");
        if (!this.initResult) {
            columnBuilder.appendNull();
        } else {
            columnBuilder.writeBinary(new Binary(this.serializeState()));
        }
    }

    @Override
    public void evaluateFinal(ColumnBuilder columnBuilder) {
        if (!this.initResult) {
            columnBuilder.appendNull();
        } else {
            columnBuilder.writeDouble(this.sumValue / (double)this.countValue);
        }
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public void addStatistics(Statistics[] statistics) {
        if (statistics == null || statistics[0] == null) {
            return;
        }
        this.initResult = true;
        this.countValue += (long)statistics[0].getCount();
        this.sumValue = statistics[0] instanceof IntegerStatistics ? (this.sumValue += (double)statistics[0].getSumLongValue()) : (this.sumValue += statistics[0].getSumDoubleValue());
        if (this.countValue == 0L) {
            this.initResult = false;
        }
    }

    @Override
    public void reset() {
        this.initResult = false;
        this.countValue = 0L;
        this.sumValue = 0.0;
    }

    @Override
    public boolean removable() {
        return true;
    }

    private byte[] serializeState() {
        byte[] bytes = new byte[16];
        BytesUtils.longToBytes((long)this.countValue, (byte[])bytes, (int)0);
        BytesUtils.doubleToBytes((double)this.sumValue, (byte[])bytes, (int)8);
        return bytes;
    }

    private void addIntInput(Column column, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (column.isNull(i)) continue;
                this.initResult = true;
                ++this.countValue;
                this.sumValue += (double)column.getInt(i);
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (column.isNull(position)) continue;
                this.initResult = true;
                ++this.countValue;
                this.sumValue += (double)column.getInt(position);
            }
        }
    }

    private void addLongInput(Column column, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (column.isNull(i)) continue;
                this.initResult = true;
                ++this.countValue;
                this.sumValue += (double)column.getLong(i);
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (column.isNull(position)) continue;
                this.initResult = true;
                ++this.countValue;
                this.sumValue += (double)column.getLong(position);
            }
        }
    }

    private void addFloatInput(Column column, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (column.isNull(i)) continue;
                this.initResult = true;
                ++this.countValue;
                this.sumValue += (double)column.getFloat(i);
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (column.isNull(position)) continue;
                this.initResult = true;
                ++this.countValue;
                this.sumValue += (double)column.getFloat(position);
            }
        }
    }

    private void addDoubleInput(Column column, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (column.isNull(i)) continue;
                this.initResult = true;
                ++this.countValue;
                this.sumValue += column.getDouble(i);
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (column.isNull(position)) continue;
                this.initResult = true;
                ++this.countValue;
                this.sumValue += column.getDouble(position);
            }
        }
    }

    private void removeIntInput(Column column) {
        int count = column.getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (column.isNull(i)) continue;
            --this.countValue;
            this.sumValue -= (double)column.getInt(i);
        }
    }

    private void removeLongInput(Column column) {
        int count = column.getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (column.isNull(i)) continue;
            --this.countValue;
            this.sumValue -= (double)column.getLong(i);
        }
    }

    private void removeFloatInput(Column column) {
        int count = column.getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (column.isNull(i)) continue;
            --this.countValue;
            this.sumValue -= (double)column.getFloat(i);
        }
    }

    private void removeDoubleInput(Column column) {
        int count = column.getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (column.isNull(i)) continue;
            --this.countValue;
            this.sumValue -= column.getDouble(i);
        }
    }
}

