/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.table.v1.impl;

import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.rest.IoTDBRestServiceDescriptor;
import org.apache.iotdb.db.protocol.rest.model.ExecutionStatus;
import org.apache.iotdb.db.protocol.rest.table.v1.NotFoundException;
import org.apache.iotdb.db.protocol.rest.table.v1.RestApiService;
import org.apache.iotdb.db.protocol.rest.table.v1.handler.ExceptionHandler;
import org.apache.iotdb.db.protocol.rest.table.v1.handler.ExecuteStatementHandler;
import org.apache.iotdb.db.protocol.rest.table.v1.handler.QueryDataSetHandler;
import org.apache.iotdb.db.protocol.rest.table.v1.handler.RequestValidationHandler;
import org.apache.iotdb.db.protocol.rest.table.v1.handler.StatementConstructionHandler;
import org.apache.iotdb.db.protocol.rest.table.v1.model.InsertTabletRequest;
import org.apache.iotdb.db.protocol.rest.table.v1.model.SQL;
import org.apache.iotdb.db.protocol.session.IClientSession;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.protocol.thrift.OperationType;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.execution.IQueryExecution;
import org.apache.iotdb.db.queryengine.plan.planner.LocalExecutionPlanner;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.parser.SqlParser;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.utils.CommonUtils;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.rpc.TSStatusCode;

public class RestApiServiceImpl
extends RestApiService {
    private static final Coordinator COORDINATOR = Coordinator.getInstance();
    private static final SessionManager SESSION_MANAGER = SessionManager.getInstance();
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final Integer defaultQueryRowLimit = IoTDBRestServiceDescriptor.getInstance().getConfig().getRestQueryDefaultRowSizeLimit();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Response executeQueryStatement(SQL sql, SecurityContext securityContext) throws NotFoundException {
        ExecutionResult result;
        long startTime;
        Statement statement;
        Long queryId;
        block20: {
            IClientSession clientSession;
            SqlParser relationSqlParser;
            block19: {
                block18: {
                    relationSqlParser = new SqlParser();
                    queryId = null;
                    statement = null;
                    startTime = System.nanoTime();
                    RequestValidationHandler.validateQuerySQL(sql);
                    clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
                    clientSession.setDatabaseName(sql.getDatabase());
                    clientSession.setSqlDialect(IClientSession.SqlDialect.TABLE);
                    statement = relationSqlParser.createStatement(sql.getSql(), ZoneId.systemDefault(), clientSession);
                    if (statement != null) break block18;
                    Response response = Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.SQL_PARSE_ERROR.getStatusCode())).message("This operation type is not supported")).build();
                    long costTime = System.nanoTime() - startTime;
                    Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_QUERY_STATEMENT, s.toString(), costTime));
                    if (queryId != null) {
                        COORDINATOR.cleanupQueryExecution(queryId);
                    }
                    return response;
                }
                if (!ExecuteStatementHandler.validateStatement(statement)) break block19;
                Response response = Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode())).message(TSStatusCode.EXECUTE_STATEMENT_ERROR.name())).build();
                long costTime = System.nanoTime() - startTime;
                Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_QUERY_STATEMENT, s.toString(), costTime));
                if (queryId != null) {
                    COORDINATOR.cleanupQueryExecution(queryId);
                }
                return response;
            }
            queryId = SESSION_MANAGER.requestQueryId();
            Metadata metadata = LocalExecutionPlanner.getInstance().metadata;
            result = COORDINATOR.executeForTableModel(statement, relationSqlParser, clientSession, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), sql.getSql(), metadata, config.getQueryTimeoutThreshold(), true);
            if (result.status.code == TSStatusCode.SUCCESS_STATUS.getStatusCode() || result.status.code == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) break block20;
            Response response = Response.ok().entity((Object)new org.apache.iotdb.db.protocol.rest.table.v1.model.ExecutionStatus().code(Integer.valueOf(result.status.getCode())).message(result.status.getMessage())).build();
            long costTime = System.nanoTime() - startTime;
            Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_QUERY_STATEMENT, s.toString(), costTime));
            if (queryId != null) {
                COORDINATOR.cleanupQueryExecution(queryId);
            }
            return response;
        }
        IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
        SetThreadName threadName = new SetThreadName(result.queryId.getId());
        Response response = QueryDataSetHandler.fillQueryDataSet(queryExecution, statement, sql.getRowLimit() == null ? this.defaultQueryRowLimit : sql.getRowLimit());
        threadName.close();
        long costTime = System.nanoTime() - startTime;
        Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_QUERY_STATEMENT, s.toString(), costTime));
        if (queryId != null) {
            COORDINATOR.cleanupQueryExecution(queryId);
        }
        return response;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            threadName.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        Response response2 = Response.ok().entity((Object)ExceptionHandler.tryCatchException(e)).build();
                        return response2;
                    }
                }
                catch (Throwable throwable3) {
                    throw throwable3;
                }
                finally {
                    long costTime2 = System.nanoTime() - startTime;
                    Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_QUERY_STATEMENT, s.toString(), costTime));
                    if (queryId != null) {
                        COORDINATOR.cleanupQueryExecution(queryId);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response insertTablet(InsertTabletRequest insertTabletRequest, SecurityContext securityContext) throws NotFoundException {
        Response response;
        Long queryId = null;
        long startTime = System.nanoTime();
        InsertTabletStatement insertTabletStatement = null;
        try {
            RequestValidationHandler.validateInsertTabletRequest(insertTabletRequest);
            insertTabletStatement = StatementConstructionHandler.constructInsertTabletStatement(insertTabletRequest);
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            clientSession.setDatabaseName(insertTabletRequest.getDatabase());
            clientSession.setSqlDialect(IClientSession.SqlDialect.TABLE);
            queryId = SESSION_MANAGER.requestQueryId();
            Metadata metadata = LocalExecutionPlanner.getInstance().metadata;
            SqlParser relationSqlParser = new SqlParser();
            ExecutionResult result = COORDINATOR.executeForTableModel(insertTabletStatement, relationSqlParser, clientSession, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), "", metadata, config.getQueryTimeoutThreshold());
            response = this.responseGenerateHelper(result);
        }
        catch (Exception e) {
            Response response2;
            try {
                response2 = Response.ok().entity((Object)ExceptionHandler.tryCatchException(e)).build();
            }
            catch (Throwable throwable) {
                long costTime = System.nanoTime() - startTime;
                Optional.ofNullable(insertTabletStatement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.INSERT_TABLET, s.getType().name(), costTime));
                if (queryId != null) {
                    COORDINATOR.cleanupQueryExecution(queryId);
                }
                throw throwable;
            }
            long costTime = System.nanoTime() - startTime;
            Optional.ofNullable(insertTabletStatement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.INSERT_TABLET, s.getType().name(), costTime));
            if (queryId != null) {
                COORDINATOR.cleanupQueryExecution(queryId);
            }
            return response2;
        }
        long costTime = System.nanoTime() - startTime;
        Optional.ofNullable(insertTabletStatement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.INSERT_TABLET, s.getType().name(), costTime));
        if (queryId != null) {
            COORDINATOR.cleanupQueryExecution(queryId);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response executeNonQueryStatement(SQL sql, SecurityContext securityContext) throws NotFoundException {
        long costTime;
        Response response;
        long startTime;
        Statement statement;
        Long queryId;
        block14: {
            long costTime2;
            Response response2;
            block13: {
                long costTime3;
                Response response3;
                block12: {
                    SqlParser relationSqlParser = new SqlParser();
                    queryId = null;
                    statement = null;
                    startTime = System.nanoTime();
                    try {
                        IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
                        RequestValidationHandler.validateSQL(sql);
                        clientSession.setDatabaseName(sql.getDatabase());
                        clientSession.setSqlDialect(IClientSession.SqlDialect.TABLE);
                        statement = relationSqlParser.createStatement(sql.getSql(), ZoneId.systemDefault(), clientSession);
                        if (statement == null) {
                            Response response4 = Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.SQL_PARSE_ERROR.getStatusCode())).message("This operation type is not supported")).build();
                            long costTime4 = System.nanoTime() - startTime;
                            Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_NON_QUERY_PLAN, s.toString(), costTime4));
                            if (queryId == null) return response4;
                            COORDINATOR.cleanupQueryExecution(queryId);
                            return response4;
                        }
                        if (!ExecuteStatementHandler.validateStatement(statement)) {
                            response3 = Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode())).message(TSStatusCode.EXECUTE_STATEMENT_ERROR.name())).build();
                            costTime3 = System.nanoTime() - startTime;
                            break block12;
                        }
                        queryId = SESSION_MANAGER.requestQueryId();
                        Metadata metadata = LocalExecutionPlanner.getInstance().metadata;
                        ExecutionResult result = COORDINATOR.executeForTableModel(statement, relationSqlParser, clientSession, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), sql.getSql(), metadata, config.getQueryTimeoutThreshold(), false);
                        if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode() && result.status.code != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                            response2 = Response.ok().entity((Object)new org.apache.iotdb.db.protocol.rest.table.v1.model.ExecutionStatus().code(Integer.valueOf(result.status.getCode())).message(result.status.getMessage())).build();
                            costTime2 = System.nanoTime() - startTime;
                            break block13;
                        }
                        response = this.responseGenerateHelper(result);
                        costTime = System.nanoTime() - startTime;
                        break block14;
                    }
                    catch (Exception e) {
                        Response response5 = Response.ok().entity((Object)ExceptionHandler.tryCatchException(e)).build();
                        return response5;
                    }
                }
                Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_NON_QUERY_PLAN, s.toString(), costTime4));
                if (queryId == null) return response3;
                COORDINATOR.cleanupQueryExecution(queryId);
                return response3;
            }
            Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_NON_QUERY_PLAN, s.toString(), costTime4));
            if (queryId == null) return response2;
            COORDINATOR.cleanupQueryExecution(queryId);
            return response2;
        }
        Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_NON_QUERY_PLAN, s.toString(), costTime4));
        if (queryId == null) return response;
        COORDINATOR.cleanupQueryExecution(queryId);
        return response;
        finally {
            long costTime5 = System.nanoTime() - startTime;
            Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_NON_QUERY_PLAN, s.toString(), costTime4));
            if (queryId != null) {
                COORDINATOR.cleanupQueryExecution(queryId);
            }
        }
    }

    private Response responseGenerateHelper(ExecutionResult result) {
        if (result.status.code == TSStatusCode.SUCCESS_STATUS.getStatusCode() || result.status.code == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
            return Response.ok().entity((Object)new org.apache.iotdb.db.protocol.rest.table.v1.model.ExecutionStatus().code(Integer.valueOf(TSStatusCode.SUCCESS_STATUS.getStatusCode())).message(TSStatusCode.SUCCESS_STATUS.name())).build();
        }
        if (result.status.code == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
            List subStatus = result.status.getSubStatus();
            StringBuilder errMsg = new StringBuilder();
            for (TSStatus status : subStatus) {
                if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || status.getCode() == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) continue;
                errMsg.append(status.getMessage()).append("; ");
            }
            return Response.ok().entity((Object)new org.apache.iotdb.db.protocol.rest.table.v1.model.ExecutionStatus().code(Integer.valueOf(TSStatusCode.MULTIPLE_ERROR.getStatusCode())).message(errMsg.toString())).build();
        }
        return Response.ok().entity((Object)new org.apache.iotdb.db.protocol.rest.table.v1.model.ExecutionStatus().code(Integer.valueOf(result.status.getCode())).message(result.status.getMessage())).build();
    }
}

