/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.consensus.metric;

import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.pipe.connector.protocol.pipeconsensus.PipeConsensusAsyncConnector;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Counter;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class PipeConsensusConnectorMetrics
implements IMetricSet {
    private final PipeConsensusAsyncConnector pipeConsensusAsyncConnector;
    private Timer connectorEnqueueTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer connectorWALTransferTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer connectorTsFileTransferTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer connectorTsFilePieceTransferTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer retryWALTransferTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer retryTsFileTransferTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Counter retryCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private static final String CONNECTOR = "pipeConsensusAsyncConnector";

    public PipeConsensusConnectorMetrics(PipeConsensusAsyncConnector pipeConsensusAsyncConnector) {
        this.pipeConsensusAsyncConnector = pipeConsensusAsyncConnector;
    }

    public void recordConnectorEnqueueTimer(long costTimeInNanos) {
        this.connectorEnqueueTimer.updateNanos(costTimeInNanos);
    }

    public void recordConnectorWalTransferTimer(long costTimeInNanos) {
        this.connectorWALTransferTimer.updateNanos(costTimeInNanos);
    }

    public void recordConnectorTsFileTransferTimer(long costTimeInNanos) {
        this.connectorTsFileTransferTimer.updateNanos(costTimeInNanos);
    }

    public void recordConnectorTsFilePieceTransferTimer(long costTimeInNanos) {
        this.connectorTsFilePieceTransferTimer.updateNanos(costTimeInNanos);
    }

    public void recordRetryWALTransferTimer(long costTimeInNanos) {
        this.retryWALTransferTimer.updateNanos(costTimeInNanos);
    }

    public void recordRetryTsFileTransferTimer(long costTimeInNanos) {
        this.retryTsFileTransferTimer.updateNanos(costTimeInNanos);
    }

    public void recordRetryCounter() {
        this.retryCounter.inc();
    }

    public void bindTo(AbstractMetricService metricService) {
        this.bindCounter(metricService);
        this.bindAutoGauge(metricService);
        this.bindTimer(metricService);
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.unbindCounter(metricService);
        this.unbindAutoGauge(metricService);
        this.unbindTimer(metricService);
    }

    private void bindCounter(AbstractMetricService metricService) {
        this.retryCounter = metricService.getOrCreateCounter(Metric.PIPE_RETRY_SEND_EVENT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), CONNECTOR, Tag.REGION.toString(), this.pipeConsensusAsyncConnector.getConsensusGroupIdStr(), Tag.TYPE.toString(), "pipeConsensusRetryCount"});
    }

    private void bindAutoGauge(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.PIPE_SEND_EVENT.toString(), MetricLevel.IMPORTANT, (Object)this.pipeConsensusAsyncConnector, PipeConsensusAsyncConnector::getTransferBufferSize, new String[]{Tag.NAME.toString(), CONNECTOR, Tag.REGION.toString(), this.pipeConsensusAsyncConnector.getConsensusGroupIdStr(), Tag.TYPE.toString(), "transferBufferSize"});
        metricService.createAutoGauge(Metric.PIPE_SEND_EVENT.toString(), MetricLevel.IMPORTANT, (Object)this.pipeConsensusAsyncConnector, PipeConsensusAsyncConnector::getRetryBufferSize, new String[]{Tag.NAME.toString(), CONNECTOR, Tag.REGION.toString(), this.pipeConsensusAsyncConnector.getConsensusGroupIdStr(), Tag.TYPE.toString(), "retryBufferSize"});
    }

    private void bindTimer(AbstractMetricService metricService) {
        this.connectorEnqueueTimer = metricService.getOrCreateTimer(Metric.PIPE_SEND_EVENT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), CONNECTOR, Tag.TYPE.toString(), "connectorEnqueue", Tag.REGION.toString(), this.pipeConsensusAsyncConnector.getConsensusGroupIdStr()});
        this.connectorTsFilePieceTransferTimer = metricService.getOrCreateTimer(Metric.PIPE_SEND_EVENT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), CONNECTOR, Tag.TYPE.toString(), "connectorTsFilePieceTransfer", Tag.REGION.toString(), this.pipeConsensusAsyncConnector.getConsensusGroupIdStr()});
        this.connectorTsFileTransferTimer = metricService.getOrCreateTimer(Metric.PIPE_SEND_EVENT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), CONNECTOR, Tag.TYPE.toString(), "connectorTsFileTransfer", Tag.REGION.toString(), this.pipeConsensusAsyncConnector.getConsensusGroupIdStr()});
        this.connectorWALTransferTimer = metricService.getOrCreateTimer(Metric.PIPE_SEND_EVENT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), CONNECTOR, Tag.TYPE.toString(), "connectorWALTransfer", Tag.REGION.toString(), this.pipeConsensusAsyncConnector.getConsensusGroupIdStr()});
        this.retryWALTransferTimer = metricService.getOrCreateTimer(Metric.PIPE_RETRY_SEND_EVENT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), CONNECTOR, Tag.TYPE.toString(), "retryWALTransfer", Tag.REGION.toString(), this.pipeConsensusAsyncConnector.getConsensusGroupIdStr()});
        this.retryTsFileTransferTimer = metricService.getOrCreateTimer(Metric.PIPE_RETRY_SEND_EVENT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), CONNECTOR, Tag.TYPE.toString(), "retryTsFileTransfer", Tag.REGION.toString(), this.pipeConsensusAsyncConnector.getConsensusGroupIdStr()});
    }

    private void unbindCounter(AbstractMetricService metricService) {
        this.retryCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
        metricService.remove(MetricType.COUNTER, Metric.PIPE_RETRY_SEND_EVENT.toString(), new String[]{Tag.NAME.toString(), CONNECTOR, Tag.REGION.toString(), this.pipeConsensusAsyncConnector.getConsensusGroupIdStr(), Tag.TYPE.toString(), "pipeConsensusRetryCount"});
    }

    private void unbindAutoGauge(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_SEND_EVENT.toString(), new String[]{Tag.NAME.toString(), CONNECTOR, Tag.REGION.toString(), this.pipeConsensusAsyncConnector.getConsensusGroupIdStr(), Tag.TYPE.toString(), "transferBufferSize"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_SEND_EVENT.toString(), new String[]{Tag.NAME.toString(), CONNECTOR, Tag.REGION.toString(), this.pipeConsensusAsyncConnector.getConsensusGroupIdStr(), Tag.TYPE.toString(), "retryBufferSize"});
    }

    private void unbindTimer(AbstractMetricService metricService) {
        this.connectorEnqueueTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.connectorWALTransferTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.connectorTsFileTransferTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.connectorTsFilePieceTransferTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.retryWALTransferTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.retryTsFileTransferTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        metricService.remove(MetricType.TIMER, Metric.PIPE_SEND_EVENT.toString(), new String[]{Tag.NAME.toString(), CONNECTOR, Tag.TYPE.toString(), "connectorTsFileTransfer", Tag.REGION.toString(), this.pipeConsensusAsyncConnector.getConsensusGroupIdStr()});
        metricService.remove(MetricType.TIMER, Metric.PIPE_SEND_EVENT.toString(), new String[]{Tag.NAME.toString(), CONNECTOR, Tag.TYPE.toString(), "connectorTsFilePieceTransfer", Tag.REGION.toString(), this.pipeConsensusAsyncConnector.getConsensusGroupIdStr()});
        metricService.remove(MetricType.TIMER, Metric.PIPE_SEND_EVENT.toString(), new String[]{Tag.NAME.toString(), CONNECTOR, Tag.TYPE.toString(), "connectorTsFileTransfer", Tag.REGION.toString(), this.pipeConsensusAsyncConnector.getConsensusGroupIdStr()});
        metricService.remove(MetricType.TIMER, Metric.PIPE_SEND_EVENT.toString(), new String[]{Tag.NAME.toString(), CONNECTOR, Tag.TYPE.toString(), "connectorWALTransfer", Tag.REGION.toString(), this.pipeConsensusAsyncConnector.getConsensusGroupIdStr()});
        metricService.remove(MetricType.TIMER, Metric.PIPE_RETRY_SEND_EVENT.toString(), new String[]{Tag.NAME.toString(), CONNECTOR, Tag.TYPE.toString(), "retryWALTransfer", Tag.REGION.toString(), this.pipeConsensusAsyncConnector.getConsensusGroupIdStr()});
        metricService.remove(MetricType.TIMER, Metric.PIPE_RETRY_SEND_EVENT.toString(), new String[]{Tag.NAME.toString(), CONNECTOR, Tag.TYPE.toString(), "retryTsFileTransfer", Tag.REGION.toString(), this.pipeConsensusAsyncConnector.getConsensusGroupIdStr()});
    }
}

