/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionTableSchemaNotMatchException;
import org.apache.tsfile.file.metadata.TableSchema;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class CompactionTableSchema
extends TableSchema {
    public CompactionTableSchema(String tableName) {
        super(tableName);
    }

    public void merge(TableSchema tableSchema) {
        if (tableSchema == null) {
            return;
        }
        if (!tableSchema.getTableName().equals(this.tableName)) {
            throw new CompactionTableSchemaNotMatchException("this.tableName is " + this.tableName + " merge tableName is " + tableSchema.getTableName());
        }
        List otherSchemaColumnSchemas = tableSchema.getColumnSchemas();
        List otherSchemaColumnCategories = tableSchema.getColumnTypes();
        ArrayList<IMeasurementSchema> idColumnSchemasToMerge = new ArrayList<IMeasurementSchema>();
        for (int i = 0; i < otherSchemaColumnCategories.size(); ++i) {
            Tablet.ColumnCategory columnCategory = (Tablet.ColumnCategory)otherSchemaColumnCategories.get(i);
            if (columnCategory != Tablet.ColumnCategory.TAG) continue;
            idColumnSchemasToMerge.add((IMeasurementSchema)otherSchemaColumnSchemas.get(i));
        }
        int prefixLength = Math.min(this.columnCategories.size(), idColumnSchemasToMerge.size());
        for (int i = 0; i < prefixLength; ++i) {
            IMeasurementSchema idColumnToMerge = (IMeasurementSchema)idColumnSchemasToMerge.get(i);
            IMeasurementSchema currentIdColumn = (IMeasurementSchema)this.measurementSchemas.get(i);
            if (idColumnToMerge.getMeasurementName().equals(currentIdColumn.getMeasurementName())) continue;
            throw new CompactionTableSchemaNotMatchException("current id column name is " + currentIdColumn.getMeasurementName() + ", other id column name in same position is " + idColumnToMerge.getMeasurementName());
        }
        List newIdColumns = idColumnSchemasToMerge.subList(prefixLength, idColumnSchemasToMerge.size());
        for (IMeasurementSchema newIdColumn : newIdColumns) {
            this.columnCategories.add(Tablet.ColumnCategory.TAG);
            this.measurementSchemas.add(newIdColumn);
        }
    }

    public CompactionTableSchema copy() {
        CompactionTableSchema tableSchema = new CompactionTableSchema(this.tableName);
        tableSchema.measurementSchemas = new ArrayList(this.measurementSchemas);
        tableSchema.columnCategories = new ArrayList(this.columnCategories);
        return tableSchema;
    }
}

