/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class LogicalExpression
extends Expression {
    private final Operator operator;
    private List<Expression> terms;

    public LogicalExpression(Operator operator, List<Expression> terms) {
        super(null);
        this.operator = Objects.requireNonNull(operator, "operator is null");
        Preconditions.checkArgument((terms.size() >= 2 ? 1 : 0) != 0, (Object)"Expected at least 2 terms");
        this.terms = ImmutableList.copyOf(terms);
    }

    public LogicalExpression(NodeLocation location, Operator operator, List<Expression> terms) {
        super(Objects.requireNonNull(location, "location is null"));
        this.operator = Objects.requireNonNull(operator, "operator is null");
        Preconditions.checkArgument((terms.size() >= 2 ? 1 : 0) != 0, (Object)"Expected at least 2 terms");
        this.terms = ImmutableList.copyOf(terms);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public List<Expression> getTerms() {
        return this.terms;
    }

    public void setTerms(List<Expression> terms) {
        this.terms = ImmutableList.copyOf(terms);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLogicalExpression(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.terms;
    }

    public static LogicalExpression and(Expression left, Expression right) {
        return new LogicalExpression(Operator.AND, (List<Expression>)ImmutableList.of((Object)left, (Object)right));
    }

    public static LogicalExpression or(Expression left, Expression right) {
        return new LogicalExpression(Operator.OR, (List<Expression>)ImmutableList.of((Object)left, (Object)right));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogicalExpression that = (LogicalExpression)o;
        return this.operator == that.operator && Objects.equals(this.terms, that.terms);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.terms});
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!LogicalExpression.sameClass(this, other)) {
            return false;
        }
        return this.operator == ((LogicalExpression)other).operator;
    }

    @Override
    public TableExpressionType getExpressionType() {
        return TableExpressionType.LOGICAL_EXPRESSION;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.operator.ordinal(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.terms.size(), (OutputStream)stream);
        for (Expression term : this.terms) {
            LogicalExpression.serialize(term, stream);
        }
    }

    public LogicalExpression(ByteBuffer byteBuffer) {
        super(null);
        this.operator = Operator.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        this.terms = new ArrayList<Expression>(size);
        while (size-- > 0) {
            this.terms.add(LogicalExpression.deserialize(byteBuffer));
        }
    }

    public static enum Operator {
        AND,
        OR;


        public Operator flip() {
            if (this == AND) {
                return OR;
            }
            if (this == OR) {
                return AND;
            }
            throw new IllegalArgumentException("Unsupported logical expression type: " + (Object)((Object)this));
        }
    }
}

