/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class OutputNode
extends SingleChildProcessNode {
    private final List<String> columnNames;
    private final List<Symbol> outputSymbols;

    public OutputNode(PlanNodeId id, PlanNode child, List<String> columnNames, List<Symbol> outputSymbols) {
        super(id, child);
        this.id = id;
        this.child = child;
        Preconditions.checkArgument((columnNames.size() == outputSymbols.size() ? 1 : 0) != 0, (Object)"columnNames and outputSymbols sizes don't match");
        this.columnNames = ImmutableList.copyOf(columnNames);
        this.outputSymbols = ImmutableList.copyOf(outputSymbols);
    }

    public OutputNode(PlanNodeId id, List<String> columnNames, List<Symbol> outputSymbols) {
        super(id);
        this.id = id;
        this.columnNames = ImmutableList.copyOf(columnNames);
        this.outputSymbols = ImmutableList.copyOf(outputSymbols);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitOutput(this, context);
    }

    @Override
    public PlanNode clone() {
        return new OutputNode(this.id, null, this.columnNames, this.outputSymbols);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.columnNames;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TABLE_OUTPUT_NODE.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.columnNames.size(), (ByteBuffer)byteBuffer);
        this.columnNames.forEach(columnName -> ReadWriteIOUtils.write((String)columnName, (ByteBuffer)byteBuffer));
        ReadWriteIOUtils.write((int)this.outputSymbols.size(), (ByteBuffer)byteBuffer);
        this.outputSymbols.forEach(symbol -> Symbol.serialize(symbol, byteBuffer));
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TABLE_OUTPUT_NODE.serialize(stream);
        ReadWriteIOUtils.write((int)this.columnNames.size(), (OutputStream)stream);
        for (String columnName : this.columnNames) {
            ReadWriteIOUtils.write((String)columnName, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((int)this.outputSymbols.size(), (OutputStream)stream);
        for (Symbol symbol : this.outputSymbols) {
            Symbol.serialize(symbol, stream);
        }
    }

    public static OutputNode deserialize(ByteBuffer byteBuffer) {
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<String> columnNames = new ArrayList<String>(size);
        while (size-- > 0) {
            columnNames.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<Symbol> outputs = new ArrayList<Symbol>(size);
        while (size-- > 0) {
            outputs.add(Symbol.deserialize(byteBuffer));
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new OutputNode(planNodeId, columnNames, outputs);
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.outputSymbols;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OutputNode outputNode = (OutputNode)o;
        return Objects.equal(this.outputSymbols, outputNode.outputSymbols);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.outputSymbols});
    }

    public String toString() {
        return "OutputNode-" + this.getPlanNodeId();
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new OutputNode(this.id, (PlanNode)Iterables.getOnlyElement(newChildren), this.columnNames, this.outputSymbols);
    }
}

