/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.OrderingScheme;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SortOrder;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.SortNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TableFunctionNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TableFunctionProcessorNode;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;

public class ImplementTableFunctionSource
implements Rule<TableFunctionNode> {
    private static final Pattern<TableFunctionNode> PATTERN = Patterns.tableFunction();

    @Override
    public Pattern<TableFunctionNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(TableFunctionNode node, Captures captures, Rule.Context context) {
        if (node.getChildren().isEmpty()) {
            return Rule.Result.ofPlanNode(new TableFunctionProcessorNode(node.getPlanNodeId(), node.getName(), node.getProperOutputs(), Optional.empty(), Optional.empty(), (List<Symbol>)ImmutableList.of(), Optional.empty(), node.getArguments()));
        }
        if (node.getChildren().size() == 1) {
            TableFunctionNode.TableArgumentProperties sourceProperties = (TableFunctionNode.TableArgumentProperties)Iterables.getOnlyElement(node.getTableArgumentProperties());
            AtomicReference<PlanNode> child = new AtomicReference<PlanNode>((PlanNode)Iterables.getOnlyElement(node.getChildren()));
            sourceProperties.getDataOrganizationSpecification().ifPresent(dataOrganizationSpecification -> {
                ImmutableList.Builder orderBy = ImmutableList.builder();
                ImmutableMap.Builder orderings = ImmutableMap.builder();
                for (Symbol symbol : dataOrganizationSpecification.getPartitionBy()) {
                    orderBy.add((Object)symbol);
                    orderings.put((Object)symbol, (Object)SortOrder.ASC_NULLS_LAST);
                }
                dataOrganizationSpecification.getOrderingScheme().ifPresent(orderingScheme -> {
                    orderBy.addAll(orderingScheme.getOrderBy());
                    orderings.putAll(orderingScheme.getOrderings());
                });
                child.set(new SortNode(context.getIdAllocator().genPlanNodeId(), (PlanNode)child.get(), new OrderingScheme((List<Symbol>)orderBy.build(), (Map<Symbol, SortOrder>)orderings.build()), false, false));
            });
            return Rule.Result.ofPlanNode(new TableFunctionProcessorNode(node.getPlanNodeId(), node.getName(), node.getProperOutputs(), Optional.of(child.get()), Optional.ofNullable(sourceProperties.getPassThroughSpecification()), sourceProperties.getRequiredColumns(), sourceProperties.getDataOrganizationSpecification(), node.getArguments()));
        }
        throw new IllegalArgumentException("table function does not support multiple source now.");
    }
}

