/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.sys.subscription;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.confignode.rpc.thrift.TShowTopicInfo;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowTopics;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.subscription.ShowTopicsStatement;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.Binary;

public class ShowTopicsTask
implements IConfigTask {
    private final ShowTopicsStatement showTopicsStatement;

    public ShowTopicsTask(ShowTopicsStatement showTopicsStatement) {
        this.showTopicsStatement = showTopicsStatement;
    }

    public ShowTopicsTask(ShowTopics showTopics) {
        this.showTopicsStatement = new ShowTopicsStatement();
        this.showTopicsStatement.setTopicName(showTopics.getTopicName());
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showTopics(this.showTopicsStatement);
    }

    public static void buildTSBlock(List<TShowTopicInfo> topicInfoList, SettableFuture<ConfigTaskResult> future) {
        TsBlockBuilder builder = new TsBlockBuilder(ColumnHeaderConstant.showTopicColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList()));
        for (TShowTopicInfo topicInfo : topicInfoList) {
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.getColumnBuilder(0).writeBinary(new Binary(topicInfo.getTopicName(), TSFileConfig.STRING_CHARSET));
            builder.getColumnBuilder(1).writeBinary(new Binary(topicInfo.getTopicAttributes(), TSFileConfig.STRING_CHARSET));
            builder.declarePosition();
        }
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), DatasetHeaderFactory.getShowTopicHeader()));
    }
}

