/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation;

import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.AggregationMask;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.TableAccumulator;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class ExtremeAccumulator
implements TableAccumulator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(ExtremeAccumulator.class);
    private static final String UNSUPPORTED_DATA_TYPE = "Unsupported data type in Extreme: %s";
    private final TSDataType seriesDataType;
    private final TsPrimitiveType extremeResult;
    private boolean initResult;

    public ExtremeAccumulator(TSDataType seriesDataType) {
        this.seriesDataType = seriesDataType;
        this.extremeResult = TsPrimitiveType.getByType((TSDataType)seriesDataType);
    }

    @Override
    public long getEstimatedSize() {
        return INSTANCE_SIZE;
    }

    @Override
    public TableAccumulator copy() {
        return new ExtremeAccumulator(this.seriesDataType);
    }

    @Override
    public void addInput(Column[] arguments, AggregationMask mask) {
        switch (this.seriesDataType) {
            case INT32: {
                this.addIntInput(arguments[0], mask);
                return;
            }
            case INT64: {
                this.addLongInput(arguments[0], mask);
                return;
            }
            case FLOAT: {
                this.addFloatInput(arguments[0], mask);
                return;
            }
            case DOUBLE: {
                this.addDoubleInput(arguments[0], mask);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format(UNSUPPORTED_DATA_TYPE, this.seriesDataType));
    }

    @Override
    public void addIntermediate(Column argument) {
        block6: for (int i = 0; i < argument.getPositionCount(); ++i) {
            if (argument.isNull(i)) continue;
            switch (this.seriesDataType) {
                case INT32: {
                    this.updateIntResult(argument.getInt(i));
                    continue block6;
                }
                case INT64: {
                    this.updateLongResult(argument.getLong(i));
                    continue block6;
                }
                case FLOAT: {
                    this.updateFloatResult(argument.getFloat(i));
                    continue block6;
                }
                case DOUBLE: {
                    this.updateDoubleResult(argument.getDouble(i));
                    continue block6;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format(UNSUPPORTED_DATA_TYPE, this.seriesDataType));
                }
            }
        }
    }

    @Override
    public void addStatistics(Statistics[] statistics) {
        if (statistics == null || statistics[0] == null) {
            return;
        }
        switch (this.seriesDataType) {
            case INT32: {
                this.updateIntResult((Integer)statistics[0].getMaxValue());
                this.updateIntResult((Integer)statistics[0].getMinValue());
                break;
            }
            case INT64: {
                this.updateLongResult((Long)statistics[0].getMaxValue());
                this.updateLongResult((Long)statistics[0].getMinValue());
                break;
            }
            case FLOAT: {
                this.updateFloatResult(((Float)statistics[0].getMaxValue()).floatValue());
                this.updateFloatResult(((Float)statistics[0].getMinValue()).floatValue());
                break;
            }
            case DOUBLE: {
                this.updateDoubleResult((Double)statistics[0].getMaxValue());
                this.updateDoubleResult((Double)statistics[0].getMinValue());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(UNSUPPORTED_DATA_TYPE, this.seriesDataType));
            }
        }
    }

    @Override
    public void evaluateIntermediate(ColumnBuilder columnBuilder) {
        if (!this.initResult) {
            columnBuilder.appendNull();
            return;
        }
        switch (this.seriesDataType) {
            case INT32: {
                columnBuilder.writeInt(this.extremeResult.getInt());
                break;
            }
            case INT64: {
                columnBuilder.writeLong(this.extremeResult.getLong());
                break;
            }
            case FLOAT: {
                columnBuilder.writeFloat(this.extremeResult.getFloat());
                break;
            }
            case DOUBLE: {
                columnBuilder.writeDouble(this.extremeResult.getDouble());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(UNSUPPORTED_DATA_TYPE, this.seriesDataType));
            }
        }
    }

    @Override
    public void evaluateFinal(ColumnBuilder columnBuilder) {
        if (!this.initResult) {
            columnBuilder.appendNull();
            return;
        }
        switch (this.seriesDataType) {
            case INT32: {
                columnBuilder.writeInt(this.extremeResult.getInt());
                break;
            }
            case INT64: {
                columnBuilder.writeLong(this.extremeResult.getLong());
                break;
            }
            case FLOAT: {
                columnBuilder.writeFloat(this.extremeResult.getFloat());
                break;
            }
            case DOUBLE: {
                columnBuilder.writeDouble(this.extremeResult.getDouble());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(UNSUPPORTED_DATA_TYPE, this.seriesDataType));
            }
        }
    }

    @Override
    public void reset() {
        this.initResult = false;
        this.extremeResult.reset();
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    private void addIntInput(Column column, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < column.getPositionCount(); ++i) {
                if (column.isNull(i)) continue;
                this.updateIntResult(column.getInt(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (column.isNull(position)) continue;
                this.updateIntResult(column.getInt(position));
            }
        }
    }

    private void updateIntResult(int val) {
        int absExtVal = Math.abs(val);
        int candidateResult = this.extremeResult.getInt();
        int absCandidateResult = Math.abs(this.extremeResult.getInt());
        if (!this.initResult || absExtVal > absCandidateResult || absExtVal == absCandidateResult && val > candidateResult) {
            this.initResult = true;
            this.extremeResult.setInt(val);
        }
    }

    private void addLongInput(Column column, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < column.getPositionCount(); ++i) {
                if (column.isNull(i)) continue;
                this.updateLongResult(column.getLong(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (column.isNull(position)) continue;
                this.updateLongResult(column.getLong(position));
            }
        }
    }

    private void updateLongResult(long val) {
        long absExtVal = Math.abs(val);
        long candidateResult = this.extremeResult.getLong();
        long absCandidateResult = Math.abs(this.extremeResult.getLong());
        if (!this.initResult || absExtVal > absCandidateResult || absExtVal == absCandidateResult && val > candidateResult) {
            this.initResult = true;
            this.extremeResult.setLong(val);
        }
    }

    private void addFloatInput(Column column, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < column.getPositionCount(); ++i) {
                if (column.isNull(i)) continue;
                this.updateFloatResult(column.getFloat(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (column.isNull(position)) continue;
                this.updateFloatResult(column.getFloat(position));
            }
        }
    }

    private void updateFloatResult(float val) {
        float absExtVal = Math.abs(val);
        float candidateResult = this.extremeResult.getFloat();
        float absCandidateResult = Math.abs(this.extremeResult.getFloat());
        if (!this.initResult || absExtVal > absCandidateResult || absExtVal == absCandidateResult && val > candidateResult) {
            this.initResult = true;
            this.extremeResult.setFloat(val);
        }
    }

    private void addDoubleInput(Column column, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < column.getPositionCount(); ++i) {
                if (column.isNull(i)) continue;
                this.updateDoubleResult(column.getDouble(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (column.isNull(position)) continue;
                this.updateDoubleResult(column.getDouble(position));
            }
        }
    }

    private void updateDoubleResult(double val) {
        double absExtVal = Math.abs(val);
        double candidateResult = this.extremeResult.getDouble();
        double absCandidateResult = Math.abs(this.extremeResult.getDouble());
        if (!this.initResult || absExtVal > absCandidateResult || absExtVal == absCandidateResult && val > candidateResult) {
            this.initResult = true;
            this.extremeResult.setDouble(val);
        }
    }
}

