/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.comparator;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.comparator.AscBinaryTypeJoinKeyComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.comparator.AscBooleanTypeJoinKeyComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.comparator.AscDoubleTypeJoinKeyComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.comparator.AscFloatTypeJoinKeyComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.comparator.AscIntTypeJoinKeyComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.comparator.AscLongTypeJoinKeyComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.comparator.DescBinaryTypeJoinKeyComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.comparator.DescBooleanTypeJoinKeyComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.comparator.DescDoubleTypeJoinKeyComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.comparator.DescFloatTypeJoinKeyComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.comparator.DescIntTypeJoinKeyComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.comparator.DescLongTypeJoinKeyComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.comparator.JoinKeyComparator;
import org.apache.tsfile.read.common.type.Type;

public class JoinKeyComparatorFactory {
    private JoinKeyComparatorFactory() {
    }

    public static List<JoinKeyComparator> getComparators(List<Type> joinKeyTypes, boolean isAscending) {
        ArrayList<JoinKeyComparator> comparators = new ArrayList<JoinKeyComparator>(joinKeyTypes.size());
        for (Type joinKeyType : joinKeyTypes) {
            comparators.add(JoinKeyComparatorFactory.getComparator(joinKeyType, isAscending));
        }
        return comparators;
    }

    public static JoinKeyComparator getComparator(Type type, boolean isAscending) {
        switch (type.getTypeEnum()) {
            case INT32: 
            case DATE: {
                return isAscending ? AscIntTypeJoinKeyComparator.getInstance() : DescIntTypeJoinKeyComparator.getInstance();
            }
            case INT64: 
            case TIMESTAMP: {
                return isAscending ? AscLongTypeJoinKeyComparator.getInstance() : DescLongTypeJoinKeyComparator.getInstance();
            }
            case FLOAT: {
                return isAscending ? AscFloatTypeJoinKeyComparator.getInstance() : DescFloatTypeJoinKeyComparator.getInstance();
            }
            case DOUBLE: {
                return isAscending ? AscDoubleTypeJoinKeyComparator.getInstance() : DescDoubleTypeJoinKeyComparator.getInstance();
            }
            case BOOLEAN: {
                return isAscending ? AscBooleanTypeJoinKeyComparator.getInstance() : DescBooleanTypeJoinKeyComparator.getInstance();
            }
            case STRING: 
            case BLOB: 
            case TEXT: {
                return isAscending ? AscBinaryTypeJoinKeyComparator.getInstance() : DescBinaryTypeJoinKeyComparator.getInstance();
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + type);
    }
}

