/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.runtime.IntoProcessException;
import org.apache.iotdb.db.protocol.client.DataNodeInternalClient;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.read.common.type.TypeFactory;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public abstract class AbstractIntoOperator
implements ProcessOperator {
    protected final OperatorContext operatorContext;
    protected final Operator child;
    protected TsBlock cachedTsBlock;
    protected List<InsertTabletStatementGenerator> insertTabletStatementGenerators;
    private DataNodeInternalClient client;
    private final ExecutorService writeOperationExecutor;
    private ListenableFuture<TSStatus> writeOperationFuture;
    protected boolean finished = false;
    protected int maxRowNumberInStatement;
    private long maxRetainedSize;
    private long maxReturnSize;
    protected final List<Type> typeConvertors;
    private static final int DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();

    protected AbstractIntoOperator(OperatorContext operatorContext, Operator child, List<TSDataType> inputColumnTypes, ExecutorService intoOperationExecutor, long statementSizePerLine) {
        this.operatorContext = operatorContext;
        this.child = child;
        this.typeConvertors = inputColumnTypes.stream().map(TypeFactory::getType).collect(Collectors.toList());
        this.writeOperationExecutor = intoOperationExecutor;
        this.initMemoryEstimates(statementSizePerLine);
    }

    private void initMemoryEstimates(long statementSizePerLine) {
        long intoOperationBufferSizeInByte = IoTDBDescriptor.getInstance().getConfig().getIntoOperationBufferSizeInByte();
        long memAllowedMaxRowNumber = Math.max(intoOperationBufferSizeInByte / statementSizePerLine, 1L);
        if (memAllowedMaxRowNumber > Integer.MAX_VALUE) {
            memAllowedMaxRowNumber = Integer.MAX_VALUE;
        }
        this.maxRowNumberInStatement = Math.min((int)memAllowedMaxRowNumber, IoTDBDescriptor.getInstance().getConfig().getSelectIntoInsertTabletPlanRowLimit());
        long maxStatementSize = (long)this.maxRowNumberInStatement * statementSizePerLine;
        this.maxRetainedSize = this.child.calculateMaxReturnSize() + maxStatementSize;
        this.maxReturnSize = DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        ListenableFuture<?> childBlocked = this.child.isBlocked();
        boolean writeDone = this.writeOperationDone();
        if (writeDone && childBlocked.isDone()) {
            return NOT_BLOCKED;
        }
        if (childBlocked.isDone()) {
            return this.writeOperationFuture;
        }
        if (writeDone) {
            return childBlocked;
        }
        return Futures.successfulAsList(Arrays.asList(this.writeOperationFuture, childBlocked));
    }

    private boolean writeOperationDone() {
        if (this.writeOperationFuture == null) {
            return true;
        }
        return this.writeOperationFuture.isDone();
    }

    @Override
    public boolean hasNext() throws Exception {
        return !this.finished;
    }

    @Override
    public TsBlock next() throws Exception {
        this.checkLastWriteOperation();
        if (!this.processTsBlock(this.cachedTsBlock)) {
            return null;
        }
        this.cachedTsBlock = null;
        if (this.child.hasNextWithTimer()) {
            TsBlock inputTsBlock = this.child.nextWithTimer();
            this.processTsBlock(inputTsBlock);
            return null;
        }
        return this.tryToReturnResultTsBlock();
    }

    private void checkLastWriteOperation() {
        if (this.writeOperationFuture == null) {
            return;
        }
        try {
            if (!this.writeOperationFuture.isDone()) {
                throw new IllegalStateException("The operator cannot continue until the last write operation is done.");
            }
            TSStatus executionStatus = (TSStatus)this.writeOperationFuture.get();
            if (executionStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && executionStatus.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                String message = String.format("Error occurred while inserting tablets in SELECT INTO: %s", executionStatus.getMessage());
                throw new IntoProcessException(message);
            }
            for (InsertTabletStatementGenerator generator : this.insertTabletStatementGenerators) {
                generator.reset();
            }
            this.writeOperationFuture = null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IntoProcessException(e.getMessage());
        }
        catch (ExecutionException e) {
            throw new IntoProcessException(e.getMessage());
        }
    }

    protected abstract boolean processTsBlock(TsBlock var1);

    protected abstract TsBlock tryToReturnResultTsBlock();

    protected static List<InsertTabletStatementGenerator> constructInsertTabletStatementGenerators(Map<PartialPath, Map<String, InputLocation>> targetPathToSourceInputLocationMap, Map<PartialPath, Map<String, TSDataType>> targetPathToDataTypeMap, Map<String, Boolean> targetDeviceToAlignedMap, List<Type> sourceTypeConvertors, int maxRowNumberInStatement) {
        ArrayList<InsertTabletStatementGenerator> insertTabletStatementGenerators = new ArrayList<InsertTabletStatementGenerator>(targetPathToSourceInputLocationMap.size());
        for (Map.Entry<PartialPath, Map<String, InputLocation>> entry : targetPathToSourceInputLocationMap.entrySet()) {
            PartialPath targetDevice = entry.getKey();
            InsertTabletStatementGenerator generator = new InsertTabletStatementGenerator(targetDevice, entry.getValue(), targetPathToDataTypeMap.get(targetDevice), targetDeviceToAlignedMap.get(targetDevice.toString()), sourceTypeConvertors, maxRowNumberInStatement);
            insertTabletStatementGenerators.add(generator);
        }
        return insertTabletStatementGenerators;
    }

    protected boolean insertMultiTabletsInternally(boolean needCheck) {
        InsertMultiTabletsStatement insertMultiTabletsStatement = this.constructInsertMultiTabletsStatement(needCheck);
        if (insertMultiTabletsStatement == null) {
            return false;
        }
        this.executeInsertMultiTabletsStatement(insertMultiTabletsStatement);
        return true;
    }

    protected InsertMultiTabletsStatement constructInsertMultiTabletsStatement(boolean needCheck) {
        if (this.insertTabletStatementGenerators == null || needCheck && !this.existFullStatement(this.insertTabletStatementGenerators)) {
            return null;
        }
        ArrayList<InsertTabletStatement> insertTabletStatementList = new ArrayList<InsertTabletStatement>();
        for (InsertTabletStatementGenerator generator : this.insertTabletStatementGenerators) {
            if (generator.isEmpty()) continue;
            insertTabletStatementList.add(generator.constructInsertTabletStatement());
        }
        if (insertTabletStatementList.isEmpty()) {
            return null;
        }
        InsertMultiTabletsStatement insertMultiTabletsStatement = new InsertMultiTabletsStatement();
        insertMultiTabletsStatement.setInsertTabletStatementList(insertTabletStatementList);
        return insertMultiTabletsStatement;
    }

    protected void executeInsertMultiTabletsStatement(InsertMultiTabletsStatement insertMultiTabletsStatement) {
        if (this.client == null) {
            this.client = new DataNodeInternalClient(this.operatorContext.getSessionInfo());
        }
        this.writeOperationFuture = Futures.submit(() -> this.client.insertTablets(insertMultiTabletsStatement), (Executor)this.writeOperationExecutor);
    }

    private boolean existFullStatement(List<InsertTabletStatementGenerator> insertTabletStatementGenerators) {
        for (InsertTabletStatementGenerator generator : insertTabletStatementGenerators) {
            if (!generator.isFull()) continue;
            return true;
        }
        return false;
    }

    protected int findWritten(String device, String measurement) {
        for (InsertTabletStatementGenerator generator : this.insertTabletStatementGenerators) {
            if (!Objects.equals(generator.getDevice(), device)) continue;
            return generator.getWrittenCount(measurement);
        }
        return 0;
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.finished;
    }

    @Override
    public void close() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
        if (this.writeOperationFuture != null) {
            this.writeOperationFuture.cancel(true);
        }
        this.child.close();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.maxReturnSize + this.maxRetainedSize + this.child.calculateMaxPeekMemoryWithCounter();
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.maxRetainedSize + this.child.calculateRetainedSizeAfterCallingNext();
    }

    @TestOnly
    public int getMaxRowNumberInStatement() {
        return this.maxRowNumberInStatement;
    }

    public static class InsertTabletStatementGenerator {
        private final int rowLimit;
        private final PartialPath devicePath;
        private final boolean isAligned;
        private final String[] measurements;
        private final TSDataType[] dataTypes;
        private final InputLocation[] inputLocations;
        private int rowCount = 0;
        private long[] times;
        private Object[] columns;
        private BitMap[] bitMaps;
        private final Map<String, AtomicInteger> writtenCounter;
        private final List<Type> sourceTypeConvertors;

        public InsertTabletStatementGenerator(PartialPath devicePath, Map<String, InputLocation> measurementToInputLocationMap, Map<String, TSDataType> measurementToDataTypeMap, Boolean isAligned, List<Type> sourceTypeConvertors, int rowLimit) {
            this.devicePath = devicePath;
            this.isAligned = isAligned;
            this.measurements = measurementToInputLocationMap.keySet().toArray(new String[0]);
            this.dataTypes = measurementToDataTypeMap.values().toArray(new TSDataType[0]);
            this.inputLocations = measurementToInputLocationMap.values().toArray(new InputLocation[0]);
            this.writtenCounter = new HashMap<String, AtomicInteger>();
            for (String measurement : this.measurements) {
                this.writtenCounter.put(measurement, new AtomicInteger(0));
            }
            this.sourceTypeConvertors = sourceTypeConvertors;
            this.rowLimit = rowLimit;
            this.reset();
        }

        public void reset() {
            int i;
            this.rowCount = 0;
            this.times = new long[this.rowLimit];
            this.columns = new Object[this.measurements.length];
            block8: for (i = 0; i < this.measurements.length; ++i) {
                switch (this.dataTypes[i]) {
                    case BOOLEAN: {
                        this.columns[i] = new boolean[this.rowLimit];
                        continue block8;
                    }
                    case INT32: 
                    case DATE: {
                        this.columns[i] = new int[this.rowLimit];
                        continue block8;
                    }
                    case INT64: 
                    case TIMESTAMP: {
                        this.columns[i] = new long[this.rowLimit];
                        continue block8;
                    }
                    case FLOAT: {
                        this.columns[i] = new float[this.rowLimit];
                        continue block8;
                    }
                    case DOUBLE: {
                        this.columns[i] = new double[this.rowLimit];
                        continue block8;
                    }
                    case TEXT: 
                    case STRING: 
                    case BLOB: {
                        this.columns[i] = new Binary[this.rowLimit];
                        Arrays.fill((Binary[])this.columns[i], Binary.EMPTY_VALUE);
                        continue block8;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", this.dataTypes[i]));
                    }
                }
            }
            this.bitMaps = new BitMap[this.measurements.length];
            for (i = 0; i < this.bitMaps.length; ++i) {
                this.bitMaps[i] = new BitMap(this.rowLimit);
                this.bitMaps[i].markAll();
            }
        }

        public int processTsBlock(TsBlock tsBlock, int lastReadIndex) {
            while (lastReadIndex < tsBlock.getPositionCount()) {
                this.times[this.rowCount] = tsBlock.getTimeByIndex(lastReadIndex);
                block9: for (int i = 0; i < this.measurements.length; ++i) {
                    int valueColumnIndex = this.inputLocations[i].getValueColumnIndex();
                    Column valueColumn = tsBlock.getValueColumns()[valueColumnIndex];
                    Type sourceTypeConvertor = this.sourceTypeConvertors.get(valueColumnIndex);
                    if (valueColumn.isNull(lastReadIndex)) continue;
                    this.bitMaps[i].unmark(this.rowCount);
                    this.writtenCounter.get(this.measurements[i]).getAndIncrement();
                    switch (this.dataTypes[i]) {
                        case INT32: 
                        case DATE: {
                            ((int[])this.columns[i])[this.rowCount] = sourceTypeConvertor.getInt(valueColumn, lastReadIndex);
                            continue block9;
                        }
                        case INT64: 
                        case TIMESTAMP: {
                            ((long[])this.columns[i])[this.rowCount] = sourceTypeConvertor.getLong(valueColumn, lastReadIndex);
                            continue block9;
                        }
                        case FLOAT: {
                            ((float[])this.columns[i])[this.rowCount] = sourceTypeConvertor.getFloat(valueColumn, lastReadIndex);
                            continue block9;
                        }
                        case DOUBLE: {
                            ((double[])this.columns[i])[this.rowCount] = sourceTypeConvertor.getDouble(valueColumn, lastReadIndex);
                            continue block9;
                        }
                        case BOOLEAN: {
                            ((boolean[])this.columns[i])[this.rowCount] = sourceTypeConvertor.getBoolean(valueColumn, lastReadIndex);
                            continue block9;
                        }
                        case TEXT: 
                        case STRING: 
                        case BLOB: {
                            ((Binary[])this.columns[i])[this.rowCount] = sourceTypeConvertor.getBinary(valueColumn, lastReadIndex);
                            continue block9;
                        }
                        default: {
                            throw new UnSupportedDataTypeException(String.format("data type %s is not supported when convert data at client", valueColumn.getDataType()));
                        }
                    }
                }
                ++this.rowCount;
                ++lastReadIndex;
                if (this.rowCount != this.rowLimit) continue;
                break;
            }
            return lastReadIndex;
        }

        public boolean isFull() {
            return this.rowCount == this.rowLimit;
        }

        public boolean isEmpty() {
            return this.rowCount == 0;
        }

        public InsertTabletStatement constructInsertTabletStatement() {
            InsertTabletStatement insertTabletStatement = new InsertTabletStatement();
            insertTabletStatement.setDevicePath(this.devicePath);
            insertTabletStatement.setAligned(this.isAligned);
            insertTabletStatement.setMeasurements(this.measurements);
            insertTabletStatement.setDataTypes(this.dataTypes);
            insertTabletStatement.setRowCount(this.rowCount);
            if (this.rowCount != this.rowLimit) {
                this.times = Arrays.copyOf(this.times, this.rowCount);
                block8: for (int i = 0; i < this.columns.length; ++i) {
                    this.bitMaps[i] = this.bitMaps[i].getRegion(0, this.rowCount);
                    switch (this.dataTypes[i]) {
                        case BOOLEAN: {
                            this.columns[i] = Arrays.copyOf((boolean[])this.columns[i], this.rowCount);
                            continue block8;
                        }
                        case INT32: 
                        case DATE: {
                            this.columns[i] = Arrays.copyOf((int[])this.columns[i], this.rowCount);
                            continue block8;
                        }
                        case INT64: 
                        case TIMESTAMP: {
                            this.columns[i] = Arrays.copyOf((long[])this.columns[i], this.rowCount);
                            continue block8;
                        }
                        case FLOAT: {
                            this.columns[i] = Arrays.copyOf((float[])this.columns[i], this.rowCount);
                            continue block8;
                        }
                        case DOUBLE: {
                            this.columns[i] = Arrays.copyOf((double[])this.columns[i], this.rowCount);
                            continue block8;
                        }
                        case TEXT: 
                        case STRING: 
                        case BLOB: {
                            this.columns[i] = Arrays.copyOf((Binary[])this.columns[i], this.rowCount);
                            continue block8;
                        }
                        default: {
                            throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", this.dataTypes[i]));
                        }
                    }
                }
            }
            insertTabletStatement.setTimes(this.times);
            insertTabletStatement.setBitMaps(this.bitMaps);
            insertTabletStatement.setColumns(this.columns);
            return insertTabletStatement;
        }

        public String getDevice() {
            return this.devicePath.toString();
        }

        public int getWrittenCount(String measurement) {
            if (!this.writtenCounter.containsKey(measurement)) {
                return -1;
            }
            return this.writtenCounter.get(measurement).get();
        }
    }
}

