/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.client;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.common.rpc.thrift.TNodeLocations;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TSetConfigurationReq;
import org.apache.iotdb.common.rpc.thrift.TSetSpaceQuotaReq;
import org.apache.iotdb.common.rpc.thrift.TSetTTLReq;
import org.apache.iotdb.common.rpc.thrift.TSetThrottleQuotaReq;
import org.apache.iotdb.common.rpc.thrift.TShowConfigurationResp;
import org.apache.iotdb.common.rpc.thrift.TShowTTLReq;
import org.apache.iotdb.common.rpc.thrift.TTestConnectionResp;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.commons.client.ThriftClient;
import org.apache.iotdb.commons.client.factory.ThriftClientFactory;
import org.apache.iotdb.commons.client.property.ThriftClientProperty;
import org.apache.iotdb.commons.client.request.TestConnectionUtils;
import org.apache.iotdb.commons.client.sync.SyncThriftClientWithErrorHandler;
import org.apache.iotdb.commons.consensus.ConfigRegionId;
import org.apache.iotdb.confignode.rpc.thrift.IConfigNodeRPCService;
import org.apache.iotdb.confignode.rpc.thrift.TAINodeConfigurationResp;
import org.apache.iotdb.confignode.rpc.thrift.TAINodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TAINodeRegisterResp;
import org.apache.iotdb.confignode.rpc.thrift.TAINodeRemoveReq;
import org.apache.iotdb.confignode.rpc.thrift.TAINodeRestartReq;
import org.apache.iotdb.confignode.rpc.thrift.TAINodeRestartResp;
import org.apache.iotdb.confignode.rpc.thrift.TAddConsensusGroupReq;
import org.apache.iotdb.confignode.rpc.thrift.TAlterLogicalViewReq;
import org.apache.iotdb.confignode.rpc.thrift.TAlterOrDropTableReq;
import org.apache.iotdb.confignode.rpc.thrift.TAlterPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TAlterSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TAuthizedPatternTreeResp;
import org.apache.iotdb.confignode.rpc.thrift.TAuthorizerRelationalReq;
import org.apache.iotdb.confignode.rpc.thrift.TAuthorizerReq;
import org.apache.iotdb.confignode.rpc.thrift.TAuthorizerResp;
import org.apache.iotdb.confignode.rpc.thrift.TCheckUserPrivilegesReq;
import org.apache.iotdb.confignode.rpc.thrift.TCloseConsumerReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeHeartbeatReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeHeartbeatResp;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterResp;
import org.apache.iotdb.confignode.rpc.thrift.TCountDatabaseResp;
import org.apache.iotdb.confignode.rpc.thrift.TCountTimeSlotListReq;
import org.apache.iotdb.confignode.rpc.thrift.TCountTimeSlotListResp;
import org.apache.iotdb.confignode.rpc.thrift.TCreateCQReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateConsumerReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateFunctionReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateModelReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipePluginReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateTopicReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeConfigurationResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRegisterResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRemoveReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRemoveResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRestartReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRestartResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataPartitionReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataPartitionTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchemaResp;
import org.apache.iotdb.confignode.rpc.thrift.TDeactivateSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteDatabaseReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteDatabasesReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteLogicalViewReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteTableDeviceReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteTableDeviceResp;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteTimeSeriesReq;
import org.apache.iotdb.confignode.rpc.thrift.TDescTable4InformationSchemaResp;
import org.apache.iotdb.confignode.rpc.thrift.TDescTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TDropCQReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropFunctionReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropModelReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropPipePluginReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropTopicReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TExtendRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TFetchTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllPipeInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllSubscriptionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllTemplatesResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllTopicInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetClusterIdResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetDataNodeLocationsResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetDatabaseReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetJarInListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetJarInListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetLocationForTriggerResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetModelInfoReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetModelInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetPathsSetTemplatesReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetPathsSetTemplatesResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetPipePluginTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetRegionIdReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetRegionIdResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetSeriesSlotListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetSeriesSlotListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTemplateResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTimeSlotListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetTimeSlotListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTriggerTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetUDFTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetUdfTableReq;
import org.apache.iotdb.confignode.rpc.thrift.TLoginReq;
import org.apache.iotdb.confignode.rpc.thrift.TMigrateRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TPermissionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TPipeConfigTransferReq;
import org.apache.iotdb.confignode.rpc.thrift.TPipeConfigTransferResp;
import org.apache.iotdb.confignode.rpc.thrift.TReconstructRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TRegionRouteMapResp;
import org.apache.iotdb.confignode.rpc.thrift.TRemoveRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaNodeManagementReq;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaNodeManagementResp;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaPartitionReq;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaPartitionTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TSetDataNodeStatusReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetDataReplicationFactorReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetSchemaReplicationFactorReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetTimePartitionIntervalReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowAINodesResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowCQResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowClusterResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowConfigNodesResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowDataNodesResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowDatabaseResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowModelReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowModelResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipePluginReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowSubscriptionReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowSubscriptionResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowTTLResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowTable4InformationSchemaResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowThrottleReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowTopicReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowTopicResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowVariablesResp;
import org.apache.iotdb.confignode.rpc.thrift.TSpaceQuotaResp;
import org.apache.iotdb.confignode.rpc.thrift.TStartPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TStopPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TSubscribeReq;
import org.apache.iotdb.confignode.rpc.thrift.TSystemConfigurationResp;
import org.apache.iotdb.confignode.rpc.thrift.TTestOperation;
import org.apache.iotdb.confignode.rpc.thrift.TThrottleQuotaResp;
import org.apache.iotdb.confignode.rpc.thrift.TUnsetSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TUnsubscribeReq;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.rpc.DeepCopyRpcTransportFactory;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNodeClient
implements IConfigNodeRPCService.Iface,
ThriftClient,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ConfigNodeClient.class);
    private static final int RETRY_NUM = 15;
    public static final String MSG_RECONNECTION_FAIL = "Fail to connect to any config node. Please check status of ConfigNodes or logs of connected DataNode";
    private static final String MSG_RECONNECTION_DATANODE_FAIL = "Failed to connect to ConfigNode %s from DataNode %s when executing %s, Exception:";
    private static final long RETRY_INTERVAL_MS = 1000L;
    private static final long WAIT_CN_LEADER_ELECTION_INTERVAL_MS = 2000L;
    private static final String UNSUPPORTED_INVOCATION = "This method is not supported for invocation by DataNode";
    private final ThriftClientProperty property;
    private IConfigNodeRPCService.Iface client;
    private TTransport transport;
    private TEndPoint configLeader;
    private List<TEndPoint> configNodes;
    private TEndPoint configNode;
    private int cursor = 0;
    private boolean isFirstInitiated;
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    ClientManager<ConfigRegionId, ConfigNodeClient> clientManager;
    ConfigRegionId configRegionId = ConfigNodeInfo.CONFIG_REGION_ID;

    public ConfigNodeClient(List<TEndPoint> configNodes, ThriftClientProperty property, ClientManager<ConfigRegionId, ConfigNodeClient> clientManager) throws TException {
        this.configNodes = configNodes;
        this.property = property;
        this.clientManager = clientManager;
        this.configLeader = this.configNodes.get(0);
        this.isFirstInitiated = true;
        this.connectAndSync();
    }

    public void connect(TEndPoint endpoint, int timeoutMs) throws TException {
        try {
            this.transport = DeepCopyRpcTransportFactory.INSTANCE.getTransport(endpoint.getIp(), endpoint.getPort(), timeoutMs);
            if (!this.transport.isOpen()) {
                this.transport.open();
            }
            this.configNode = endpoint;
        }
        catch (TTransportException e) {
            throw new TException((Throwable)e);
        }
        this.client = new IConfigNodeRPCService.Client(this.property.getProtocolFactory().getProtocol(this.transport));
    }

    private void connectAndSync() throws TException {
        try {
            this.tryToConnect(this.property.getConnectionTimeoutMs());
        }
        catch (TException e) {
            this.syncLatestConfigNodeList();
            this.tryToConnect(this.property.getConnectionTimeoutMs());
        }
    }

    private void connectAndSync(int timeoutMs) throws TException {
        try {
            this.tryToConnect(timeoutMs);
        }
        catch (TException e) {
            this.syncLatestConfigNodeList();
            this.tryToConnect(timeoutMs);
        }
    }

    private void tryToConnect(int timeoutMs) throws TException {
        if (this.configLeader != null) {
            try {
                this.connect(this.configLeader, timeoutMs);
                return;
            }
            catch (TException ignore) {
                logger.warn("The current node leader may have been down {}, try next node", (Object)this.configLeader);
                this.configLeader = null;
            }
        } else {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
                logger.warn("Unexpected interruption when waiting to try to connect to ConfigNode");
            }
        }
        if (this.transport != null) {
            this.transport.close();
        }
        for (int tryHostNum = 0; tryHostNum < this.configNodes.size(); ++tryHostNum) {
            this.cursor = (this.cursor + 1) % this.configNodes.size();
            TEndPoint tryEndpoint = this.configNodes.get(this.cursor);
            try {
                this.connect(tryEndpoint, timeoutMs);
                return;
            }
            catch (TException ignore) {
                logger.warn("The current node may have been down {},try next node", (Object)tryEndpoint);
                continue;
            }
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TTransport getTransport() {
        return this.transport;
    }

    public void syncLatestConfigNodeList() {
        this.configNodes = ConfigNodeInfo.getInstance().getLatestConfigNodes();
        this.cursor = 0;
    }

    @Override
    public void close() {
        this.clientManager.returnClient((Object)this.configRegionId, (Object)this);
    }

    public void invalidate() {
        Optional.ofNullable(this.transport).ifPresent(TTransport::close);
    }

    public void invalidateAll() {
        this.clientManager.clear((Object)ConfigNodeInfo.CONFIG_REGION_ID);
    }

    public boolean printLogWhenEncounterException() {
        return this.property.isPrintLogWhenEncounterException();
    }

    private boolean updateConfigNodeLeader(TSStatus status) {
        try {
            if (status.getCode() == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                this.configLeader = status.isSetRedirectNode() ? new TEndPoint(status.getRedirectNode().getIp(), status.getRedirectNode().getPort()) : null;
                if (!this.isFirstInitiated) {
                    logger.info("Failed to connect to ConfigNode {} from DataNode {}, because the current node is not leader or not ready yet, will try again later", (Object)this.configNode, (Object)this.config.getAddressAndPort());
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.isFirstInitiated = false;
        }
    }

    private <T> T executeRemoteCallWithRetry(Operation<T> call, Predicate<T> check) throws TException {
        int detectedNodeNum = 0;
        for (int i = 0; i < 15; ++i) {
            try {
                T result = call.execute();
                if (check.test(result)) {
                    return result;
                }
                ++detectedNodeNum;
            }
            catch (TException e) {
                String message = String.format(MSG_RECONNECTION_DATANODE_FAIL, this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[2].getMethodName());
                logger.warn(message, (Throwable)e);
                this.configLeader = null;
            }
            if (detectedNodeNum >= this.configNodes.size()) {
                detectedNodeNum = 0;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                    logger.warn("Unexpected interruption when waiting to try to connect to ConfigNode, may because current node has been down. Will break current execution process to avoid meaningless wait.");
                    break;
                }
            }
            this.connectAndSync();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSystemConfigurationResp getSystemConfiguration() throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getSystemConfiguration(), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TGetClusterIdResp getClusterId() throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getClusterId(), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TDataNodeRegisterResp registerDataNode(TDataNodeRegisterReq req) throws TException {
        for (int i = 0; i < 15; ++i) {
            try {
                TDataNodeRegisterResp resp = this.client.registerDataNode(req);
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
                ArrayList<TEndPoint> newConfigNodes = new ArrayList<TEndPoint>();
                for (TConfigNodeLocation configNodeLocation : resp.getConfigNodeList()) {
                    newConfigNodes.add(configNodeLocation.getInternalEndPoint());
                }
                this.configNodes = newConfigNodes;
            }
            catch (TException e) {
                String message = String.format(MSG_RECONNECTION_DATANODE_FAIL, this.configNode, this.config.getAddressAndPort(), Thread.currentThread().getStackTrace()[1].getMethodName());
                logger.warn(message, (Throwable)e);
                this.configLeader = null;
            }
            this.connectAndSync();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TDataNodeRestartResp restartDataNode(TDataNodeRestartReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.restartDataNode(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TAINodeRegisterResp registerAINode(TAINodeRegisterReq req) throws TException {
        throw new UnsupportedOperationException(UNSUPPORTED_INVOCATION);
    }

    public TAINodeRestartResp restartAINode(TAINodeRestartReq req) throws TException {
        throw new UnsupportedOperationException(UNSUPPORTED_INVOCATION);
    }

    public TSStatus removeAINode(TAINodeRemoveReq req) throws TException {
        throw new UnsupportedOperationException(UNSUPPORTED_INVOCATION);
    }

    public TShowAINodesResp showAINodes() throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.showAINodes(), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TAINodeConfigurationResp getAINodeConfiguration(int aiNodeId) throws TException {
        throw new UnsupportedOperationException(UNSUPPORTED_INVOCATION);
    }

    public TDataNodeRemoveResp removeDataNode(TDataNodeRemoveReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.removeDataNode(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TSStatus reportDataNodeShutdown(TDataNodeLocation dataNodeLocation) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.reportDataNodeShutdown(dataNodeLocation), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TDataNodeConfigurationResp getDataNodeConfiguration(int dataNodeId) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getDataNodeConfiguration(dataNodeId), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TShowClusterResp showCluster() throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.showCluster(), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TShowVariablesResp showVariables() throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.showVariables(), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TSStatus setDatabase(TDatabaseSchema databaseSchema) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.setDatabase(databaseSchema), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus alterDatabase(TDatabaseSchema databaseSchema) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.alterDatabase(databaseSchema), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus deleteDatabase(TDeleteDatabaseReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.deleteDatabase(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus deleteDatabases(TDeleteDatabasesReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.deleteDatabases(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TCountDatabaseResp countMatchedDatabases(TGetDatabaseReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.countMatchedDatabases(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TDatabaseSchemaResp getMatchedDatabaseSchemas(TGetDatabaseReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getMatchedDatabaseSchemas(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TShowTTLResp showTTL(TShowTTLReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.showTTL(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TSStatus callSpecialProcedure(TTestOperation operation) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.callSpecialProcedure(operation), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus setTTL(TSetTTLReq setTTLReq) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.setTTL(setTTLReq), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus setSchemaReplicationFactor(TSetSchemaReplicationFactorReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.setSchemaReplicationFactor(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus setDataReplicationFactor(TSetDataReplicationFactorReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.setDataReplicationFactor(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus setTimePartitionInterval(TSetTimePartitionIntervalReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.setTimePartitionInterval(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSchemaPartitionTableResp getSchemaPartitionTable(TSchemaPartitionReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getSchemaPartitionTable(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TSchemaPartitionTableResp getSchemaPartitionTableWithSlots(Map<String, List<TSeriesPartitionSlot>> dbSlotMap) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getSchemaPartitionTableWithSlots(dbSlotMap), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TSchemaPartitionTableResp getOrCreateSchemaPartitionTable(TSchemaPartitionReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getOrCreateSchemaPartitionTable(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TSchemaPartitionTableResp getOrCreateSchemaPartitionTableWithSlots(Map<String, List<TSeriesPartitionSlot>> dbSlotMap) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getOrCreateSchemaPartitionTableWithSlots(dbSlotMap), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TSchemaNodeManagementResp getSchemaNodeManagementPartition(TSchemaNodeManagementReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getSchemaNodeManagementPartition(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TDataPartitionTableResp getDataPartitionTable(TDataPartitionReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getDataPartitionTable(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TDataPartitionTableResp getOrCreateDataPartitionTable(TDataPartitionReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getOrCreateDataPartitionTable(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TSStatus operatePermission(TAuthorizerReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.operatePermission(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus operateRPermission(TAuthorizerRelationalReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.operateRPermission(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TAuthorizerResp queryPermission(TAuthorizerReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.queryPermission(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TAuthorizerResp queryRPermission(TAuthorizerRelationalReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.queryRPermission(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TPermissionInfoResp login(TLoginReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.login(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TPermissionInfoResp checkUserPrivileges(TCheckUserPrivilegesReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.checkUserPrivileges(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TAuthizedPatternTreeResp fetchAuthizedPatternTree(TCheckUserPrivilegesReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.fetchAuthizedPatternTree(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TPermissionInfoResp checkRoleOfUser(TAuthorizerReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.checkRoleOfUser(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TConfigNodeRegisterResp registerConfigNode(TConfigNodeRegisterReq req) throws TException {
        throw new TException("DataNode to ConfigNode client doesn't support registerConfigNode.");
    }

    public TSStatus addConsensusGroup(TAddConsensusGroupReq registerResp) throws TException {
        throw new TException("DataNode to ConfigNode client doesn't support addConsensusGroup.");
    }

    public TSStatus notifyRegisterSuccess() throws TException {
        throw new TException("DataNode to ConfigNode client doesn't support notifyRegisterSuccess.");
    }

    public TSStatus removeConfigNode(TConfigNodeLocation configNodeLocation) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.removeConfigNode(configNodeLocation), resp -> !this.updateConfigNodeLeader((TSStatus)resp));
    }

    public TSStatus deleteConfigNodePeer(TConfigNodeLocation configNodeLocation) throws TException {
        throw new TException("DataNode to ConfigNode client doesn't support removeConsensusGroup.");
    }

    public TSStatus reportConfigNodeShutdown(TConfigNodeLocation configNodeLocation) throws TException {
        throw new TException("DataNode to ConfigNode client doesn't support reportConfigNodeShutdown.");
    }

    public TSStatus stopAndClearConfigNode(TConfigNodeLocation configNodeLocation) throws TException {
        throw new TException("DataNode to ConfigNode client doesn't support stopAndClearConfigNode.");
    }

    public TSStatus merge() throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.merge(), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus flush(TFlushReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.flush(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus clearCache(Set<Integer> clearCacheOptions) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.clearCache(clearCacheOptions), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus setConfiguration(TSetConfigurationReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.setConfiguration(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus startRepairData() throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.startRepairData(), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus stopRepairData() throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.stopRepairData(), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus submitLoadConfigurationTask() throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.submitLoadConfigurationTask(), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus loadConfiguration() throws TException {
        throw new UnsupportedOperationException("This method is not supported for invocation by DataNode, please call submitLoadConfigurationTask instead");
    }

    public TShowConfigurationResp showConfiguration(int nodeId) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.showConfiguration(nodeId), resp -> !this.updateConfigNodeLeader(resp.getStatus()));
    }

    public TSStatus setSystemStatus(String systemStatus) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.setSystemStatus(systemStatus), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus setDataNodeStatus(TSetDataNodeStatusReq req) throws TException {
        throw new TException("DataNode to ConfigNode client doesn't support setDataNodeStatus.");
    }

    public TSStatus killQuery(String queryId, int dataNodeId) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.killQuery(queryId, dataNodeId), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TGetDataNodeLocationsResp getReadableDataNodeLocations() throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getReadableDataNodeLocations(), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TShowRegionResp showRegion(TShowRegionReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.showRegion(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TShowDataNodesResp showDataNodes() throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.showDataNodes(), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TShowConfigNodesResp showConfigNodes() throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.showConfigNodes(), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TShowDatabaseResp showDatabase(TGetDatabaseReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.showDatabase(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TTestConnectionResp submitTestConnectionTask(TNodeLocations nodeLocations) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.submitTestConnectionTask(nodeLocations), resp -> !this.updateConfigNodeLeader(resp.getStatus()));
    }

    public TTestConnectionResp submitTestConnectionTaskToLeader() throws TException {
        try {
            this.connectAndSync(TestConnectionUtils.calculateDnToCnLeaderMaxTime());
            TTestConnectionResp tTestConnectionResp = this.executeRemoteCallWithRetry(() -> this.client.submitTestConnectionTaskToLeader(), resp -> !this.updateConfigNodeLeader(resp.getStatus()));
            return tTestConnectionResp;
        }
        finally {
            this.connectAndSync();
        }
    }

    public TSStatus testConnectionEmptyRPC() throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.testConnectionEmptyRPC(), resp -> !this.updateConfigNodeLeader((TSStatus)resp));
    }

    public TRegionRouteMapResp getLatestRegionRouteMap() throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getLatestRegionRouteMap(), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TConfigNodeHeartbeatResp getConfigNodeHeartBeat(TConfigNodeHeartbeatReq req) throws TException {
        throw new TException("DataNode to ConfigNode client doesn't support getConfigNodeHeartBeat.");
    }

    public TSStatus createFunction(TCreateFunctionReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.createFunction(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus dropFunction(TDropFunctionReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.dropFunction(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TGetUDFTableResp getUDFTable(TGetUdfTableReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getUDFTable(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TGetJarInListResp getUDFJar(TGetJarInListReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getUDFJar(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TSStatus createTrigger(TCreateTriggerReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.createTrigger(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus dropTrigger(TDropTriggerReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.dropTrigger(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TGetLocationForTriggerResp getLocationOfStatefulTrigger(String triggerName) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getLocationOfStatefulTrigger(triggerName), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TGetTriggerTableResp getTriggerTable() throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getTriggerTable(), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TGetTriggerTableResp getStatefulTriggerTable() throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getStatefulTriggerTable(), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TGetJarInListResp getTriggerJar(TGetJarInListReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getTriggerJar(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TSStatus createPipePlugin(TCreatePipePluginReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.createPipePlugin(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus dropPipePlugin(TDropPipePluginReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.dropPipePlugin(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TGetPipePluginTableResp getPipePluginTable() throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getPipePluginTable(), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TGetPipePluginTableResp getPipePluginTableExtended(TShowPipePluginReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getPipePluginTableExtended(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TGetJarInListResp getPipePluginJar(TGetJarInListReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getPipePluginJar(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TSStatus createSchemaTemplate(TCreateSchemaTemplateReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.createSchemaTemplate(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TGetAllTemplatesResp getAllTemplates() throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getAllTemplates(), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TGetTemplateResp getTemplate(String req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getTemplate(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TSStatus setSchemaTemplate(TSetSchemaTemplateReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.setSchemaTemplate(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TGetPathsSetTemplatesResp getPathsSetTemplate(TGetPathsSetTemplatesReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getPathsSetTemplate(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TSStatus deactivateSchemaTemplate(TDeactivateSchemaTemplateReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.deactivateSchemaTemplate(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus unsetSchemaTemplate(TUnsetSchemaTemplateReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.unsetSchemaTemplate(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus dropSchemaTemplate(String req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.dropSchemaTemplate(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus alterSchemaTemplate(TAlterSchemaTemplateReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.alterSchemaTemplate(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus deleteTimeSeries(TDeleteTimeSeriesReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.deleteTimeSeries(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus deleteLogicalView(TDeleteLogicalViewReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.deleteLogicalView(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus alterLogicalView(TAlterLogicalViewReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.alterLogicalView(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus createPipe(TCreatePipeReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.createPipe(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus alterPipe(TAlterPipeReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.alterPipe(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus startPipe(String pipeName) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.startPipe(pipeName), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus startPipeExtended(TStartPipeReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.startPipeExtended(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus stopPipe(String pipeName) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.stopPipe(pipeName), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus stopPipeExtended(TStopPipeReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.stopPipeExtended(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus dropPipe(String pipeName) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.dropPipe(pipeName), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus dropPipeExtended(TDropPipeReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.dropPipeExtended(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TShowPipeResp showPipe(TShowPipeReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.showPipe(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TGetAllPipeInfoResp getAllPipeInfo() throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getAllPipeInfo(), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TSStatus createTopic(TCreateTopicReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.createTopic(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus dropTopic(String topicName) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.dropTopic(topicName), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus dropTopicExtended(TDropTopicReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.dropTopicExtended(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TShowTopicResp showTopic(TShowTopicReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.showTopic(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TGetAllTopicInfoResp getAllTopicInfo() throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getAllTopicInfo(), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TSStatus createConsumer(TCreateConsumerReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.createConsumer(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus closeConsumer(TCloseConsumerReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.closeConsumer(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus createSubscription(TSubscribeReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.createSubscription(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus dropSubscription(TUnsubscribeReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.dropSubscription(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TShowSubscriptionResp showSubscription(TShowSubscriptionReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.showSubscription(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TGetAllSubscriptionInfoResp getAllSubscriptionInfo() throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getAllSubscriptionInfo(), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TPipeConfigTransferResp handleTransferConfigPlan(TPipeConfigTransferReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.handleTransferConfigPlan(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TSStatus handlePipeConfigClientExit(String clientId) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.handlePipeConfigClientExit(clientId), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TGetRegionIdResp getRegionId(TGetRegionIdReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getRegionId(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TGetTimeSlotListResp getTimeSlotList(TGetTimeSlotListReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getTimeSlotList(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TCountTimeSlotListResp countTimeSlotList(TCountTimeSlotListReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.countTimeSlotList(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TGetSeriesSlotListResp getSeriesSlotList(TGetSeriesSlotListReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getSeriesSlotList(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TSStatus migrateRegion(TMigrateRegionReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.migrateRegion(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus reconstructRegion(TReconstructRegionReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.reconstructRegion(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus extendRegion(TExtendRegionReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.extendRegion(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus removeRegion(TRemoveRegionReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.removeRegion(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus createCQ(TCreateCQReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.createCQ(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus dropCQ(TDropCQReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.dropCQ(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TShowCQResp showCQ() throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.showCQ(), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TSStatus createModel(TCreateModelReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.createModel(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus dropModel(TDropModelReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.dropModel(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TShowModelResp showModel(TShowModelReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.showModel(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TGetModelInfoResp getModelInfo(TGetModelInfoReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getModelInfo(req), resp -> !this.updateConfigNodeLeader(resp.getStatus()));
    }

    public TSStatus setSpaceQuota(TSetSpaceQuotaReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.setSpaceQuota(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSpaceQuotaResp showSpaceQuota(List<String> databases) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.showSpaceQuota(databases), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TSpaceQuotaResp getSpaceQuota() throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getSpaceQuota(), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TSStatus setThrottleQuota(TSetThrottleQuotaReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.setThrottleQuota(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TThrottleQuotaResp showThrottleQuota(TShowThrottleReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.showThrottleQuota(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TThrottleQuotaResp getThrottleQuota() throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.getThrottleQuota(), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TSStatus createTable(ByteBuffer tableInfo) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.createTable(tableInfo), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TSStatus alterOrDropTable(TAlterOrDropTableReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.alterOrDropTable(req), status -> !this.updateConfigNodeLeader((TSStatus)status));
    }

    public TShowTableResp showTables(String database, boolean isDetails) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.showTables(database, isDetails), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TShowTable4InformationSchemaResp showTables4InformationSchema() throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.showTables4InformationSchema(), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TDescTableResp describeTable(String database, String tableName, boolean isDetails) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.describeTable(database, tableName, isDetails), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TDescTable4InformationSchemaResp descTables4InformationSchema() throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.descTables4InformationSchema(), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TFetchTableResp fetchTables(Map<String, Set<String>> fetchTableMap) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.fetchTables(fetchTableMap), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    public TDeleteTableDeviceResp deleteDevice(TDeleteTableDeviceReq req) throws TException {
        return this.executeRemoteCallWithRetry(() -> this.client.deleteDevice(req), resp -> !this.updateConfigNodeLeader(resp.status));
    }

    @FunctionalInterface
    private static interface Operation<T> {
        public T execute() throws TException;
    }

    public static class Factory
    extends ThriftClientFactory<ConfigRegionId, ConfigNodeClient> {
        public Factory(ClientManager<ConfigRegionId, ConfigNodeClient> clientManager, ThriftClientProperty thriftClientProperty) {
            super(clientManager, thriftClientProperty);
        }

        public void destroyObject(ConfigRegionId configRegionId, PooledObject<ConfigNodeClient> pooledObject) {
            ((ConfigNodeClient)pooledObject.getObject()).invalidate();
        }

        public PooledObject<ConfigNodeClient> makeObject(ConfigRegionId configRegionId) throws Exception {
            return new DefaultPooledObject((Object)((ConfigNodeClient)SyncThriftClientWithErrorHandler.newErrorHandler(ConfigNodeClient.class, ConfigNodeClient.class.getConstructor(List.class, this.thriftClientProperty.getClass(), this.clientManager.getClass()), (Object[])new Object[]{ConfigNodeInfo.getInstance().getLatestConfigNodes(), this.thriftClientProperty, this.clientManager})));
        }

        public boolean validateObject(ConfigRegionId configRegionId, PooledObject<ConfigNodeClient> pooledObject) {
            return Optional.ofNullable(((ConfigNodeClient)pooledObject.getObject()).getTransport()).map(TTransport::isOpen).orElse(false);
        }
    }
}

