/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.dataregion;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.pipe.datastructure.options.PipeInclusionOptions;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TreePattern;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.tsfile.utils.Pair;

public class DataRegionListeningFilter {
    private static final Set<PartialPath> OPTION_SET = new HashSet<PartialPath>();

    public static boolean shouldDatabaseBeListened(PipeParameters parameters, boolean isTableModel, String databaseRawName) throws IllegalPathException {
        boolean hasSpecificListeningOption;
        Pair<Boolean, Boolean> insertionDeletionListeningOptionPair = DataRegionListeningFilter.parseInsertionDeletionListeningOptionPair(parameters);
        boolean bl = hasSpecificListeningOption = (Boolean)insertionDeletionListeningOptionPair.getLeft() != false || (Boolean)insertionDeletionListeningOptionPair.getRight() != false;
        if (!hasSpecificListeningOption) {
            return false;
        }
        if (isTableModel) {
            String databaseTableModel = databaseRawName.startsWith("root.") ? databaseRawName.substring(5) : databaseRawName;
            TablePattern tablePattern = TablePattern.parsePipePatternFromSourceParameters((PipeParameters)parameters);
            return tablePattern.isTableModelDataAllowedToBeCaptured() && tablePattern.matchesDatabase(databaseTableModel);
        }
        String databaseTreeModel = databaseRawName.startsWith("root.") ? databaseRawName : "root." + databaseRawName;
        TreePattern treePattern = TreePattern.parsePipePatternFromSourceParameters((PipeParameters)parameters);
        return treePattern.isTreeModelDataAllowedToBeCaptured() && treePattern.mayOverlapWithDb(databaseTreeModel);
    }

    public static boolean shouldDataRegionBeListened(PipeParameters parameters, DataRegionId dataRegionId) throws IllegalPathException {
        boolean hasSpecificListeningOption;
        Pair<Boolean, Boolean> insertionDeletionListeningOptionPair = DataRegionListeningFilter.parseInsertionDeletionListeningOptionPair(parameters);
        boolean bl = hasSpecificListeningOption = (Boolean)insertionDeletionListeningOptionPair.getLeft() != false || (Boolean)insertionDeletionListeningOptionPair.getRight() != false;
        if (!hasSpecificListeningOption) {
            return false;
        }
        DataRegion dataRegion = StorageEngine.getInstance().getDataRegion(dataRegionId);
        if (dataRegion == null) {
            return true;
        }
        String databaseRawName = dataRegion.getDatabaseName();
        String databaseTreeModel = databaseRawName.startsWith("root.") ? databaseRawName : "root." + databaseRawName;
        String databaseTableModel = databaseRawName.startsWith("root.") ? databaseRawName.substring(5) : databaseRawName;
        TreePattern treePattern = TreePattern.parsePipePatternFromSourceParameters((PipeParameters)parameters);
        TablePattern tablePattern = TablePattern.parsePipePatternFromSourceParameters((PipeParameters)parameters);
        return treePattern.isTreeModelDataAllowedToBeCaptured() && treePattern.mayOverlapWithDb(databaseTreeModel) || tablePattern.isTableModelDataAllowedToBeCaptured() && tablePattern.matchesDatabase(databaseTableModel);
    }

    public static Pair<Boolean, Boolean> parseInsertionDeletionListeningOptionPair(PipeParameters parameters) throws IllegalPathException, IllegalArgumentException {
        HashSet listeningOptions = new HashSet();
        Set inclusionOptions = PipeInclusionOptions.parseOptions((String)PipeInclusionOptions.getInclusionString((PipeParameters)parameters));
        Set exclusionOptions = PipeInclusionOptions.parseOptions((String)PipeInclusionOptions.getExclusionString((PipeParameters)parameters));
        inclusionOptions.forEach(inclusion -> listeningOptions.addAll(OPTION_SET.stream().filter(path -> path.overlapWithFullPathPrefix(inclusion)).map(PartialPath::getFullPath).collect(Collectors.toSet())));
        exclusionOptions.forEach(exclusion -> listeningOptions.removeAll(OPTION_SET.stream().filter(path -> path.overlapWithFullPathPrefix(exclusion)).map(PartialPath::getFullPath).collect(Collectors.toSet())));
        return new Pair((Object)listeningOptions.contains("data.insert"), (Object)listeningOptions.contains("data.delete"));
    }

    static {
        try {
            OPTION_SET.add(new PartialPath("data.insert"));
            OPTION_SET.add(new PartialPath("data.delete"));
        }
        catch (IllegalPathException illegalPathException) {
            // empty catch block
        }
    }
}

