/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.response.pipe.plugin;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.pipe.agent.plugin.meta.PipePluginMeta;
import org.apache.iotdb.commons.pipe.datastructure.visibility.Visibility;
import org.apache.iotdb.commons.pipe.datastructure.visibility.VisibilityUtils;
import org.apache.iotdb.confignode.rpc.thrift.TGetPipePluginTableResp;
import org.apache.iotdb.consensus.common.DataSet;

public class PipePluginTableResp
implements DataSet {
    private final TSStatus status;
    private final List<PipePluginMeta> allPipePluginMeta;
    private final Map<String, Visibility> pipePluginNameToVisibilityMap;

    public PipePluginTableResp(TSStatus status, List<PipePluginMeta> allPipePluginMeta, Map<String, Visibility> pipePluginNameToVisibilityMap) {
        this.status = status;
        this.allPipePluginMeta = allPipePluginMeta;
        this.pipePluginNameToVisibilityMap = pipePluginNameToVisibilityMap;
    }

    public TGetPipePluginTableResp convertToThriftResponse() throws IOException {
        ArrayList<ByteBuffer> pipePluginInformationByteBuffers = new ArrayList<ByteBuffer>();
        for (PipePluginMeta pipePluginMeta : this.allPipePluginMeta) {
            pipePluginInformationByteBuffers.add(pipePluginMeta.serialize());
        }
        return new TGetPipePluginTableResp(this.status, pipePluginInformationByteBuffers);
    }

    public PipePluginTableResp filter(boolean isTableModel) {
        return new PipePluginTableResp(this.status, this.allPipePluginMeta.stream().filter(meta -> {
            String pipePluginName = meta.getPluginName();
            Visibility visibility = this.pipePluginNameToVisibilityMap.getOrDefault(pipePluginName, Visibility.TREE_ONLY);
            return VisibilityUtils.isCompatible((Visibility)visibility, (boolean)isTableModel);
        }).collect(Collectors.toList()), this.pipePluginNameToVisibilityMap);
    }
}

