/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.confignode.client.async.CnToDnAsyncRequestType;
import org.apache.iotdb.confignode.client.async.CnToDnInternalServiceAsyncRequestManager;
import org.apache.iotdb.confignode.client.async.handlers.DataNodeAsyncRequestContext;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureSuspendedException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureYieldException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.SchemaUtils;
import org.apache.iotdb.confignode.procedure.state.schema.UnsetTemplateState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.db.exception.metadata.template.TemplateIsInUseException;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.db.schemaengine.template.TemplateInternalRPCUpdateType;
import org.apache.iotdb.db.schemaengine.template.TemplateInternalRPCUtil;
import org.apache.iotdb.mpp.rpc.thrift.TUpdateTemplateReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsetTemplateProcedure
extends StateMachineProcedure<ConfigNodeProcedureEnv, UnsetTemplateState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnsetTemplateProcedure.class);
    private String queryId;
    private Template template;
    private PartialPath path;
    private boolean alreadyRollback = false;
    private transient ByteBuffer addTemplateSetInfo;
    private transient ByteBuffer invalidateTemplateSetInfo;

    public UnsetTemplateProcedure(boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
    }

    public UnsetTemplateProcedure(String queryId, Template template, PartialPath path, boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
        this.queryId = queryId;
        this.template = template;
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, UnsetTemplateState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        long startTime = System.currentTimeMillis();
        try {
            switch (state) {
                case CONSTRUCT_BLACK_LIST: {
                    LOGGER.info("Construct schemaengine black list of template {} set on {}", (Object)this.template.getName(), (Object)this.path);
                    this.constructBlackList(env);
                    break;
                }
                case CLEAN_DATANODE_TEMPLATE_CACHE: {
                    LOGGER.info("Invalidate cache of template {} set on {}", (Object)this.template.getName(), (Object)this.path);
                    this.invalidateCache(env);
                    break;
                }
                case CHECK_DATANODE_TEMPLATE_ACTIVATION: {
                    LOGGER.info("Check DataNode template activation of template {} set on {}", (Object)this.template.getName(), (Object)this.path);
                    if (this.isFailed()) {
                        StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.NO_MORE_STATE;
                        return flow;
                    }
                    if (this.checkDataNodeTemplateActivation(env)) {
                        this.setFailure(new ProcedureException((Throwable)new TemplateIsInUseException(this.path.getFullPath())));
                        StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.NO_MORE_STATE;
                        return flow;
                    }
                    this.setNextState(UnsetTemplateState.UNSET_SCHEMA_TEMPLATE);
                    break;
                }
                case UNSET_SCHEMA_TEMPLATE: {
                    LOGGER.info("Unset template {} on {}", (Object)this.template.getName(), (Object)this.path);
                    this.unsetTemplate(env);
                    StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.NO_MORE_STATE;
                    return flow;
                }
                default: {
                    this.setFailure(new ProcedureException("Unrecognized state " + (Object)((Object)state)));
                    StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.NO_MORE_STATE;
                    return flow;
                }
            }
            StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.HAS_MORE_STATE;
            return flow;
        }
        finally {
            LOGGER.info("UnsetTemplate-[{}] costs {}ms", (Object)state, (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private void constructBlackList(ConfigNodeProcedureEnv env) {
        TSStatus status = env.getConfigManager().getClusterSchemaManager().preUnsetSchemaTemplate(this.template.getId(), this.path);
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setNextState(UnsetTemplateState.CLEAN_DATANODE_TEMPLATE_CACHE);
        } else {
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status.getMessage(), status.getCode())));
        }
    }

    private void invalidateCache(ConfigNodeProcedureEnv env) {
        try {
            this.executeInvalidateCache(env);
            this.setNextState(UnsetTemplateState.CHECK_DATANODE_TEMPLATE_ACTIVATION);
        }
        catch (ProcedureException e) {
            this.setFailure(e);
        }
    }

    private void executeInvalidateCache(ConfigNodeProcedureEnv env) throws ProcedureException {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = env.getConfigManager().getNodeManager().getRegisteredDataNodeLocations();
        TUpdateTemplateReq invalidateTemplateSetInfoReq = new TUpdateTemplateReq();
        invalidateTemplateSetInfoReq.setType(TemplateInternalRPCUpdateType.INVALIDATE_TEMPLATE_SET_INFO.toByte());
        invalidateTemplateSetInfoReq.setTemplateInfo(this.getInvalidateTemplateSetInfo());
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnAsyncRequestType.UPDATE_TEMPLATE, invalidateTemplateSetInfoReq, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        Map statusMap = clientHandler.getResponseMap();
        for (TSStatus status : statusMap.values()) {
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            LOGGER.error("Failed to invalidate template cache of template {} set on {}", (Object)this.template.getName(), (Object)this.path);
            throw new ProcedureException(new MetadataException("Invalidate template cache failed"));
        }
    }

    private boolean checkDataNodeTemplateActivation(ConfigNodeProcedureEnv env) {
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(this.path);
        patternTree.appendPathPattern((PartialPath)this.path.concatAsMeasurementPath("**"));
        try {
            return SchemaUtils.checkDataNodeTemplateActivation(env.getConfigManager(), patternTree, this.template);
        }
        catch (MetadataException e) {
            this.setFailure(new ProcedureException(new MetadataException(String.format("Unset template %s from %s failed when [check DataNode template activation] because %s", this.template.getName(), this.path, e.getMessage()))));
            return false;
        }
    }

    private void unsetTemplate(ConfigNodeProcedureEnv env) {
        TSStatus status = env.getConfigManager().getClusterSchemaManager().unsetSchemaTemplateInBlackList(this.template.getId(), this.path, this.isGeneratedByPipe);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status.getMessage(), status.getCode())));
        }
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, UnsetTemplateState unsetTemplateState) throws IOException, InterruptedException, ProcedureException {
        ProcedureException rollbackException;
        if (this.alreadyRollback) {
            return;
        }
        this.alreadyRollback = true;
        try {
            this.executeRollbackInvalidateCache(env);
            TSStatus status = env.getConfigManager().getClusterSchemaManager().rollbackPreUnsetSchemaTemplate(this.template.getId(), this.path);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return;
            }
            LOGGER.error("Failed to rollback pre unset template operation of template {} set on {}", (Object)this.template.getName(), (Object)this.path);
            rollbackException = new ProcedureException(new MetadataException("Rollback template pre unset failed because of" + status.getMessage()));
        }
        catch (ProcedureException e) {
            rollbackException = e;
        }
        try {
            this.executeInvalidateCache(env);
            this.setFailure(rollbackException);
        }
        catch (ProcedureException exception) {
            this.setFailure(new ProcedureException(new MetadataException("Rollback unset template failed and the cluster template info management is strictly broken. Please try unset again.")));
        }
    }

    private void executeRollbackInvalidateCache(ConfigNodeProcedureEnv env) throws ProcedureException {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = env.getConfigManager().getNodeManager().getRegisteredDataNodeLocations();
        TUpdateTemplateReq rollbackTemplateSetInfoReq = new TUpdateTemplateReq();
        rollbackTemplateSetInfoReq.setType(TemplateInternalRPCUpdateType.ROLLBACK_INVALIDATE_TEMPLATE_SET_INFO.toByte());
        rollbackTemplateSetInfoReq.setTemplateInfo(this.getAddTemplateSetInfo());
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnAsyncRequestType.UPDATE_TEMPLATE, rollbackTemplateSetInfoReq, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        Map statusMap = clientHandler.getResponseMap();
        for (TSStatus status : statusMap.values()) {
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            LOGGER.error("Failed to rollback template cache of template {} set on {}", (Object)this.template.getName(), (Object)this.path);
            throw new ProcedureException(new MetadataException("Rollback template cache failed"));
        }
    }

    private ByteBuffer getAddTemplateSetInfo() {
        if (this.addTemplateSetInfo == null) {
            this.addTemplateSetInfo = ByteBuffer.wrap(TemplateInternalRPCUtil.generateAddTemplateSetInfoBytes((Template)this.template, (String)this.path.getFullPath()));
        }
        return this.addTemplateSetInfo;
    }

    @Override
    protected boolean isRollbackSupported(UnsetTemplateState unsetTemplateState) {
        return true;
    }

    @Override
    protected UnsetTemplateState getState(int stateId) {
        return UnsetTemplateState.values()[stateId];
    }

    @Override
    protected int getStateId(UnsetTemplateState unsetTemplateState) {
        return unsetTemplateState.ordinal();
    }

    @Override
    protected UnsetTemplateState getInitialState() {
        return UnsetTemplateState.CONSTRUCT_BLACK_LIST;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public int getTemplateId() {
        return this.template.getId();
    }

    public String getTemplateName() {
        return this.template.getName();
    }

    public Template getTemplate() {
        return this.template;
    }

    public PartialPath getPath() {
        return this.path;
    }

    private ByteBuffer getInvalidateTemplateSetInfo() {
        if (this.invalidateTemplateSetInfo == null) {
            this.invalidateTemplateSetInfo = ByteBuffer.wrap(TemplateInternalRPCUtil.generateInvalidateTemplateSetInfoBytes((int)this.template.getId(), (String)this.path.getFullPath()));
        }
        return this.invalidateTemplateSetInfo;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(this.isGeneratedByPipe ? ProcedureType.PIPE_ENRICHED_UNSET_TEMPLATE_PROCEDURE.getTypeCode() : ProcedureType.UNSET_TEMPLATE_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.queryId, (OutputStream)stream);
        this.template.serialize((OutputStream)stream);
        this.path.serialize((OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.alreadyRollback, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.queryId = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.template = new Template();
        this.template.deserialize(byteBuffer);
        this.path = (PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer);
        this.alreadyRollback = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnsetTemplateProcedure that = (UnsetTemplateProcedure)o;
        return Objects.equals(this.getProcId(), that.getProcId()) && Objects.equals(this.getCurrentState(), that.getCurrentState()) && Objects.equals(this.getCycles(), that.getCycles()) && Objects.equals(this.isGeneratedByPipe, that.isGeneratedByPipe) && Objects.equals(this.queryId, that.queryId) && Objects.equals(this.template, that.template) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.getProcId(), this.getCurrentState(), this.getCycles(), this.isGeneratedByPipe, this.queryId, this.template, this.path);
    }
}

