/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.source;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.pipe.datastructure.options.PipeInclusionOptions;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.write.template.CommitSetSchemaTemplatePlan;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;

public class ConfigRegionListeningFilter {
    private static final Map<PartialPath, List<ConfigPhysicalPlanType>> OPTION_PLAN_MAP = new HashMap<PartialPath, List<ConfigPhysicalPlanType>>();

    static boolean shouldPlanBeListened(ConfigPhysicalPlan plan) {
        ConfigPhysicalPlanType type = plan.getType();
        if (type.equals((Object)ConfigPhysicalPlanType.CommitSetSchemaTemplate) && ((CommitSetSchemaTemplatePlan)plan).isRollback()) {
            return false;
        }
        return type.equals((Object)ConfigPhysicalPlanType.PipeEnriched) || type.equals((Object)ConfigPhysicalPlanType.UnsetTemplate) || OPTION_PLAN_MAP.values().stream().anyMatch(types -> types.contains((Object)type));
    }

    public static Set<ConfigPhysicalPlanType> parseListeningPlanTypeSet(PipeParameters parameters) throws IllegalPathException {
        HashSet<ConfigPhysicalPlanType> planTypes = new HashSet<ConfigPhysicalPlanType>();
        Set inclusionOptions = PipeInclusionOptions.parseOptions((String)parameters.getStringOrDefault(Arrays.asList("extractor.inclusion", "source.inclusion"), "data.insert"));
        Set exclusionOptions = PipeInclusionOptions.parseOptions((String)parameters.getStringOrDefault(Arrays.asList("extractor.inclusion.exclusion", "source.inclusion.exclusion"), ""));
        inclusionOptions.forEach(inclusion -> planTypes.addAll(OPTION_PLAN_MAP.keySet().stream().filter(path -> path.overlapWithFullPathPrefix(inclusion)).map(OPTION_PLAN_MAP::get).flatMap(Collection::stream).collect(Collectors.toSet())));
        exclusionOptions.forEach(exclusion -> planTypes.removeAll(OPTION_PLAN_MAP.keySet().stream().filter(path -> path.overlapWithFullPathPrefix(exclusion)).map(OPTION_PLAN_MAP::get).flatMap(Collection::stream).collect(Collectors.toSet())));
        return planTypes;
    }

    private ConfigRegionListeningFilter() {
    }

    static {
        try {
            OPTION_PLAN_MAP.put(new PartialPath("schema.database.create"), Collections.singletonList(ConfigPhysicalPlanType.CreateDatabase));
            OPTION_PLAN_MAP.put(new PartialPath("schema.database.alter"), Collections.singletonList(ConfigPhysicalPlanType.AlterDatabase));
            OPTION_PLAN_MAP.put(new PartialPath("schema.database.drop"), Collections.singletonList(ConfigPhysicalPlanType.DeleteDatabase));
            OPTION_PLAN_MAP.put(new PartialPath("schema.timeseries.template.create"), Collections.singletonList(ConfigPhysicalPlanType.CreateSchemaTemplate));
            OPTION_PLAN_MAP.put(new PartialPath("schema.timeseries.template.set"), Collections.singletonList(ConfigPhysicalPlanType.CommitSetSchemaTemplate));
            OPTION_PLAN_MAP.put(new PartialPath("schema.timeseries.template.alter"), Collections.singletonList(ConfigPhysicalPlanType.ExtendSchemaTemplate));
            OPTION_PLAN_MAP.put(new PartialPath("schema.timeseries.template.drop"), Collections.singletonList(ConfigPhysicalPlanType.DropSchemaTemplate));
            OPTION_PLAN_MAP.put(new PartialPath("schema.timeseries.template.unset"), Collections.unmodifiableList(Arrays.asList(ConfigPhysicalPlanType.UnsetTemplate, ConfigPhysicalPlanType.PipeUnsetTemplate)));
            OPTION_PLAN_MAP.put(new PartialPath("schema.timeseries.ordinary.drop"), Collections.singletonList(ConfigPhysicalPlanType.PipeDeleteTimeSeries));
            OPTION_PLAN_MAP.put(new PartialPath("schema.timeseries.view.drop"), Collections.singletonList(ConfigPhysicalPlanType.PipeDeleteLogicalView));
            OPTION_PLAN_MAP.put(new PartialPath("schema.timeseries.template.deactivate"), Collections.singletonList(ConfigPhysicalPlanType.PipeDeactivateTemplate));
            OPTION_PLAN_MAP.put(new PartialPath("schema.ttl"), Collections.singletonList(ConfigPhysicalPlanType.SetTTL));
            OPTION_PLAN_MAP.put(new PartialPath("auth.role.create"), Collections.singletonList(ConfigPhysicalPlanType.CreateRole));
            OPTION_PLAN_MAP.put(new PartialPath("auth.role.drop"), Collections.singletonList(ConfigPhysicalPlanType.DropRole));
            OPTION_PLAN_MAP.put(new PartialPath("auth.role.grant"), Collections.singletonList(ConfigPhysicalPlanType.GrantRole));
            OPTION_PLAN_MAP.put(new PartialPath("auth.role.revoke"), Collections.singletonList(ConfigPhysicalPlanType.RevokeRole));
            OPTION_PLAN_MAP.put(new PartialPath("auth.user.create"), Collections.unmodifiableList(Arrays.asList(ConfigPhysicalPlanType.CreateUser, ConfigPhysicalPlanType.CreateUserWithRawPassword)));
            OPTION_PLAN_MAP.put(new PartialPath("auth.user.alter"), Collections.singletonList(ConfigPhysicalPlanType.UpdateUser));
            OPTION_PLAN_MAP.put(new PartialPath("auth.user.drop"), Collections.singletonList(ConfigPhysicalPlanType.DropUser));
            OPTION_PLAN_MAP.put(new PartialPath("auth.user.grant"), Collections.unmodifiableList(Arrays.asList(ConfigPhysicalPlanType.GrantUser, ConfigPhysicalPlanType.GrantRoleToUser)));
            OPTION_PLAN_MAP.put(new PartialPath("auth.user.revoke"), Collections.unmodifiableList(Arrays.asList(ConfigPhysicalPlanType.RevokeUser, ConfigPhysicalPlanType.RevokeRoleFromUser)));
        }
        catch (IllegalPathException illegalPathException) {
            // empty catch block
        }
    }
}

