/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.it.env;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.it.env.cluster.env.MultiClusterEnv;
import org.apache.iotdb.it.framework.IoTDBTestLogger;
import org.apache.iotdb.itbase.env.BaseEnv;
import org.slf4j.Logger;

public class MultiEnvFactory {
    private static final List<BaseEnv> envList = new ArrayList<BaseEnv>();
    private static final Logger logger = IoTDBTestLogger.logger;
    private static String currentMethodName;

    private MultiEnvFactory() {
    }

    public static void setTestMethodName(String testMethodName) {
        currentMethodName = testMethodName;
        envList.forEach(baseEnv -> baseEnv.setTestMethodName(testMethodName));
    }

    public static BaseEnv getEnv(int index) throws IndexOutOfBoundsException {
        return envList.get(index);
    }

    public static void createEnv(int num) {
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < num; ++i) {
            try {
                Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
                envList.add(new MultiClusterEnv(startTime, i, currentMethodName));
                continue;
            }
            catch (ClassNotFoundException e) {
                logger.error("Create env error", (Throwable)e);
                System.exit(-1);
            }
        }
    }
}

