/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.example.relational;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.relational.TableFunction;
import org.apache.iotdb.udf.api.relational.table.MapTableFunctionHandle;
import org.apache.iotdb.udf.api.relational.table.TableFunctionAnalysis;
import org.apache.iotdb.udf.api.relational.table.TableFunctionHandle;
import org.apache.iotdb.udf.api.relational.table.TableFunctionProcessorProvider;
import org.apache.iotdb.udf.api.relational.table.argument.Argument;
import org.apache.iotdb.udf.api.relational.table.argument.DescribedSchema;
import org.apache.iotdb.udf.api.relational.table.argument.ScalarArgument;
import org.apache.iotdb.udf.api.relational.table.processor.TableFunctionLeafProcessor;
import org.apache.iotdb.udf.api.relational.table.specification.ParameterSpecification;
import org.apache.iotdb.udf.api.relational.table.specification.ScalarParameterSpecification;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.utils.Binary;

public class MySplit
implements TableFunction {
    private final String INPUT_PARAMETER_NAME = "input";
    private final String SPLIT_PARAMETER_NAME = "split";

    public List<ParameterSpecification> getArgumentsSpecifications() {
        return Arrays.asList(ScalarParameterSpecification.builder().name("input").type(Type.STRING).build(), ScalarParameterSpecification.builder().name("split").type(Type.STRING).defaultValue((Object)",").build());
    }

    public TableFunctionAnalysis analyze(Map<String, Argument> arguments) throws UDFException {
        DescribedSchema schema = DescribedSchema.builder().addField("output", Type.STRING).build();
        MapTableFunctionHandle handle = new MapTableFunctionHandle.Builder().addProperty("input", ((ScalarArgument)arguments.get("input")).getValue()).addProperty("split", ((ScalarArgument)arguments.get("split")).getValue()).build();
        return TableFunctionAnalysis.builder().properColumnSchema(schema).handle((TableFunctionHandle)handle).build();
    }

    public TableFunctionHandle createTableFunctionHandle() {
        return new MapTableFunctionHandle();
    }

    public TableFunctionProcessorProvider getProcessorProvider(final TableFunctionHandle tableFunctionHandle) {
        return new TableFunctionProcessorProvider(){

            public TableFunctionLeafProcessor getSplitProcessor() {
                return new SplitProcessor((String)((MapTableFunctionHandle)tableFunctionHandle).getProperty("input"), (String)((MapTableFunctionHandle)tableFunctionHandle).getProperty("split"));
            }
        };
    }

    private static class SplitProcessor
    implements TableFunctionLeafProcessor {
        private final String input;
        private final String split;
        private boolean finish = false;

        SplitProcessor(String input, String split) {
            this.input = input;
            this.split = split;
        }

        public void process(List<ColumnBuilder> columnBuilders) {
            for (String s : this.input.split(this.split)) {
                columnBuilders.get(0).writeBinary(new Binary(s, Charset.defaultCharset()));
            }
            this.finish = true;
        }

        public boolean isFinish() {
            return this.finish;
        }
    }
}

