/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.example;

import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminateTester
implements UDTF {
    private static final Logger logger = LoggerFactory.getLogger(TerminateTester.class);
    private Long maxTime;
    private int count;

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) {
        logger.debug("TerminateTester#beforeStart");
        configurations.setOutputDataType(Type.INT32).setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy());
        this.maxTime = null;
        this.count = 0;
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        this.maxTime = row.getTime();
        ++this.count;
        collector.putInt(this.maxTime.longValue(), 1);
    }

    public void terminate(PointCollector collector) throws Exception {
        if (this.maxTime != null) {
            collector.putInt(this.maxTime + 1L, this.count);
        }
    }

    public void beforeDestroy() {
        logger.debug("TerminateTester#beforeDestroy");
    }
}

