/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.itbase.env;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.rpc.thrift.IConfigNodeRPCService;
import org.apache.iotdb.isession.ISession;
import org.apache.iotdb.isession.ITableSession;
import org.apache.iotdb.isession.pool.ISessionPool;
import org.apache.iotdb.isession.pool.ITableSessionPool;
import org.apache.iotdb.it.env.cluster.node.AbstractNodeWrapper;
import org.apache.iotdb.it.env.cluster.node.ConfigNodeWrapper;
import org.apache.iotdb.it.env.cluster.node.DataNodeWrapper;
import org.apache.iotdb.itbase.env.BaseNodeWrapper;
import org.apache.iotdb.itbase.env.ClusterConfig;
import org.apache.iotdb.jdbc.Constant;
import org.apache.iotdb.rpc.IoTDBConnectionException;

public interface BaseEnv {
    public static final String TREE_SQL_DIALECT = "tree";
    public static final String TABLE_SQL_DIALECT = "table";

    public void initClusterEnvironment();

    public void initClusterEnvironment(int var1, int var2);

    public void initClusterEnvironment(int var1, int var2, int var3);

    public void cleanClusterEnvironment();

    public ClusterConfig getConfig();

    default public String getUrlContent(String urlStr) {
        StringBuilder sb = new StringBuilder();
        try {
            BufferedReader bufr;
            URL url = new URL(urlStr);
            HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
            if (httpConnection.getResponseCode() == 200) {
                String str;
                InputStream in = httpConnection.getInputStream();
                InputStreamReader isr = new InputStreamReader(in);
                bufr = new BufferedReader(isr);
                while ((str = bufr.readLine()) != null) {
                    sb.append(str);
                    sb.append('\n');
                }
            } else {
                return null;
            }
            bufr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return sb.toString();
    }

    public List<String> getMetricPrometheusReporterContents();

    default public Connection getConnection() throws SQLException {
        return this.getConnection("root", "root", TREE_SQL_DIALECT);
    }

    default public Connection getTableConnection() throws SQLException {
        return this.getConnection("root", "root", TABLE_SQL_DIALECT);
    }

    default public Connection getConnection(String sqlDialect) throws SQLException {
        return this.getConnection("root", "root", sqlDialect);
    }

    default public Connection getConnection(Constant.Version version) throws SQLException {
        return this.getConnection(version, "root", "root", TREE_SQL_DIALECT);
    }

    default public Connection getConnection(Constant.Version version, String sqlDialect) throws SQLException {
        return this.getConnection(version, "root", "root", sqlDialect);
    }

    default public Connection getConnection(Constant.Version version, String username, String password) throws SQLException {
        return this.getConnection(version, username, password, TREE_SQL_DIALECT);
    }

    public Connection getConnection(Constant.Version var1, String var2, String var3, String var4) throws SQLException;

    public Connection getConnection(DataNodeWrapper var1, String var2, String var3, String var4) throws SQLException;

    default public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection(username, password, TREE_SQL_DIALECT);
    }

    public Connection getConnection(String var1, String var2, String var3) throws SQLException;

    default public Connection getWriteOnlyConnectionWithSpecifiedDataNode(DataNodeWrapper dataNode) throws SQLException {
        return this.getWriteOnlyConnectionWithSpecifiedDataNode(dataNode, "root", "root", TREE_SQL_DIALECT);
    }

    default public Connection getWriteOnlyConnectionWithSpecifiedDataNode(DataNodeWrapper dataNode, String sqlDialect) throws SQLException {
        return this.getWriteOnlyConnectionWithSpecifiedDataNode(dataNode, "root", "root", sqlDialect);
    }

    public Connection getWriteOnlyConnectionWithSpecifiedDataNode(DataNodeWrapper var1, String var2, String var3, String var4) throws SQLException;

    default public Connection getConnectionWithSpecifiedDataNode(DataNodeWrapper dataNode) throws SQLException {
        return this.getConnectionWithSpecifiedDataNode(dataNode, "root", "root");
    }

    public Connection getConnectionWithSpecifiedDataNode(DataNodeWrapper var1, String var2, String var3) throws SQLException;

    public void setTestMethodName(String var1);

    public void dumpTestJVMSnapshot();

    public List<AbstractNodeWrapper> getNodeWrapperList();

    public List<ConfigNodeWrapper> getConfigNodeWrapperList();

    public List<DataNodeWrapper> getDataNodeWrapperList();

    public IConfigNodeRPCService.Iface getLeaderConfigNodeConnection() throws ClientManagerException, IOException, InterruptedException;

    public ISessionPool getSessionPool(int var1);

    public ITableSessionPool getTableSessionPool(int var1);

    public ITableSessionPool getTableSessionPool(int var1, String var2);

    public ISession getSessionConnection() throws IoTDBConnectionException;

    public ISession getSessionConnection(ZoneId var1) throws IoTDBConnectionException;

    public ISession getSessionConnection(String var1, String var2) throws IoTDBConnectionException;

    public ISession getSessionConnection(List<String> var1) throws IoTDBConnectionException;

    public ITableSession getTableSessionConnection() throws IoTDBConnectionException;

    public ITableSession getTableSessionConnectionWithDB(String var1) throws IoTDBConnectionException;

    public ITableSession getTableSessionConnection(List<String> var1) throws IoTDBConnectionException;

    public ITableSession getTableSessionConnection(String var1, String var2) throws IoTDBConnectionException;

    public int getFirstLeaderSchemaRegionDataNodeIndex() throws IOException, InterruptedException;

    public int getLeaderConfigNodeIndex() throws IOException, InterruptedException;

    default public IConfigNodeRPCService.Iface getConfigNodeConnection(int index) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void startConfigNode(int var1);

    public void startAllConfigNodes();

    public void shutdownConfigNode(int var1);

    public void shutdownAllConfigNodes();

    public void ensureNodeStatus(List<BaseNodeWrapper> var1, List<NodeStatus> var2) throws IllegalStateException;

    public ConfigNodeWrapper getConfigNodeWrapper(int var1);

    public DataNodeWrapper getDataNodeWrapper(int var1);

    public ConfigNodeWrapper generateRandomConfigNodeWrapper();

    public DataNodeWrapper generateRandomDataNodeWrapper();

    public void registerNewDataNode(boolean var1);

    public void registerNewDataNode(DataNodeWrapper var1, boolean var2);

    public void registerNewConfigNode(boolean var1);

    public void registerNewConfigNode(ConfigNodeWrapper var1, boolean var2);

    public void startDataNode(int var1);

    public void startAllDataNodes();

    public void shutdownDataNode(int var1);

    public void shutdownAllDataNodes();

    public void shutdownForciblyAllDataNodes();

    public int getMqttPort();

    public String getIP();

    public String getPort();

    public String getSbinPath();

    public String getToolsPath();

    public String getLibPath();

    public Optional<DataNodeWrapper> dataNodeIdToWrapper(int var1);

    public void registerConfigNodeKillPoints(List<String> var1);

    public void registerDataNodeKillPoints(List<String> var1);

    public static Properties constructProperties(String username, String password, String sqlDialect) {
        Properties info = new Properties();
        if (username != null) {
            info.put("user", username);
        }
        if (password != null) {
            info.put("password", password);
        }
        if (sqlDialect != null) {
            info.put("sql_dialect", sqlDialect);
        }
        return info;
    }
}

