/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.it.env.cluster.node;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.it.env.cluster.EnvUtils;
import org.apache.iotdb.it.env.cluster.config.MppJVMConfig;
import org.apache.iotdb.it.env.cluster.node.AbstractNodeWrapper;
import org.apache.iotdb.it.framework.IoTDBTestLogger;
import org.slf4j.Logger;

public class AINodeWrapper
extends AbstractNodeWrapper {
    private static final Logger logger = IoTDBTestLogger.logger;
    private final long startTime;
    private final String seedConfigNode;
    private static final String SCRIPT_FILE = "start-ainode.sh";
    private static final String SHELL_COMMAND = "bash";
    private static final String PROPERTIES_FILE = "iotdb-ainode.properties";
    public static final String CONFIG_PATH = "conf";
    public static final String SCRIPT_PATH = "sbin";

    private void replaceAttribute(String[] keys, String[] values, String filePath) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(filePath, true));){
            for (int i = 0; i < keys.length; ++i) {
                String line = keys[i] + "=" + values[i];
                writer.newLine();
                writer.write(line);
            }
        }
        catch (IOException e) {
            logger.error("Failed to set attribute for AINode in file: {} because {}", (Object)filePath, (Object)e.getMessage());
        }
    }

    public AINodeWrapper(String seedConfigNode, String testClassName, String testMethodName, int clusterIndex, int[] port, long startTime) {
        super(testClassName, testMethodName, port, clusterIndex, false, startTime);
        this.seedConfigNode = seedConfigNode;
        this.startTime = startTime;
    }

    @Override
    public String getLogDirPath() {
        return System.getProperty("user.dir") + File.separator + "target" + File.separator + "ainode-logs" + File.separator + this.getTestLogDirName() + File.separator + EnvUtils.getTimeForLogDirectory(this.startTime);
    }

    @Override
    String getNodeType() {
        return "ainode";
    }

    @Override
    public void start() {
        try {
            File stdoutFile = new File(this.getLogPath());
            String filePrefix = System.getProperty("user.dir") + File.separator + "target" + File.separator + "AINode" + this.getPort();
            String propertiesFile = filePrefix + File.separator + CONFIG_PATH + File.separator + PROPERTIES_FILE;
            this.replaceAttribute(new String[]{"ain_seed_config_node", "ain_inference_rpc_port"}, new String[]{this.seedConfigNode, Integer.toString(this.getPort())}, propertiesFile);
            ArrayList<String> startCommand = new ArrayList<String>();
            startCommand.add(SHELL_COMMAND);
            startCommand.add(filePrefix + File.separator + SCRIPT_PATH + File.separator + SCRIPT_FILE);
            startCommand.add("-i");
            startCommand.add(filePrefix + File.separator + "venv/bin/python3");
            startCommand.add("-r");
            ProcessBuilder processBuilder = new ProcessBuilder(startCommand).redirectOutput(ProcessBuilder.Redirect.appendTo(stdoutFile)).redirectError(ProcessBuilder.Redirect.appendTo(stdoutFile));
            this.instance = processBuilder.start();
            logger.info("In test {} {} started.", (Object)this.getTestLogDirName(), (Object)this.getId());
        }
        catch (Exception e) {
            throw new AssertionError((Object)("Start AI Node failed. " + e + Paths.get("", new String[0])));
        }
    }

    @Override
    public int getMetricPort() {
        return -1;
    }

    @Override
    public String getId() {
        return "AINode" + this.getPort();
    }

    @Override
    public void reloadMutableFields() {
    }

    @Override
    public void renameFile() {
    }

    @Override
    public String getSystemConfigPath() {
        return "";
    }

    @Override
    public String getDefaultNodeConfigPath() {
        return "";
    }

    @Override
    public String getDefaultCommonConfigPath() {
        return "";
    }

    @Override
    public void addStartCmdParams(List<String> params) {
    }

    @Override
    public String getSystemPropertiesPath() {
        return "";
    }

    @Override
    public MppJVMConfig initVMConfig() {
        return null;
    }
}

