/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.example.relational;

import java.nio.ByteBuffer;
import org.apache.iotdb.udf.api.State;
import org.apache.iotdb.udf.api.customizer.analysis.AggregateFunctionAnalysis;
import org.apache.iotdb.udf.api.customizer.parameter.FunctionArguments;
import org.apache.iotdb.udf.api.exception.UDFArgumentNotValidException;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.relational.AggregateFunction;
import org.apache.iotdb.udf.api.relational.access.Record;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.iotdb.udf.api.utils.ResultValue;

public class MyAvg
implements AggregateFunction {
    public AggregateFunctionAnalysis analyze(FunctionArguments arguments) throws UDFArgumentNotValidException {
        if (arguments.getArgumentsSize() != 1) {
            throw new UDFArgumentNotValidException("MyAvg only accepts one column as input");
        }
        if (arguments.getDataType(0) != Type.INT32 && arguments.getDataType(0) != Type.INT64 && arguments.getDataType(0) != Type.FLOAT && arguments.getDataType(0) != Type.DOUBLE) {
            throw new UDFArgumentNotValidException("MyAvg only accepts INT32, INT64, FLOAT, DOUBLE as input");
        }
        return new AggregateFunctionAnalysis.Builder().outputDataType(Type.DOUBLE).removable(true).build();
    }

    public State createState() {
        return new AvgState();
    }

    public void addInput(State state, Record input) {
        if (!input.isNull(0)) {
            AvgState avgState = (AvgState)state;
            switch (input.getDataType(0)) {
                case INT32: {
                    avgState.sum += (double)input.getInt(0);
                    break;
                }
                case INT64: {
                    avgState.sum += (double)input.getLong(0);
                    break;
                }
                case FLOAT: {
                    avgState.sum += (double)input.getFloat(0);
                    break;
                }
                case DOUBLE: {
                    avgState.sum += input.getDouble(0);
                    break;
                }
                default: {
                    throw new UDFException("MyAvg only accepts INT32, INT64, FLOAT, DOUBLE as input");
                }
            }
            ++avgState.count;
        }
    }

    public void combineState(State state, State rhs) {
        AvgState avgState = (AvgState)state;
        AvgState avgRhs = (AvgState)rhs;
        avgState.sum += avgRhs.sum;
        avgState.count += avgRhs.count;
    }

    public void outputFinal(State state, ResultValue resultValue) {
        AvgState avgState = (AvgState)state;
        if (avgState.count != 0L) {
            resultValue.setDouble(avgState.sum / (double)avgState.count);
        } else {
            resultValue.setNull();
        }
    }

    static class AvgState
    implements State {
        double sum;
        long count;

        AvgState() {
        }

        public void reset() {
            this.sum = 0.0;
            this.count = 0L;
        }

        public byte[] serialize() {
            ByteBuffer buffer = ByteBuffer.allocate(16);
            buffer.putDouble(this.sum);
            buffer.putLong(this.count);
            return buffer.array();
        }

        public void deserialize(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            this.sum = buffer.getDouble();
            this.count = buffer.getLong();
        }
    }
}

