/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.example;

import java.io.IOException;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SessionTimeWindowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingTimeWindowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.StateWindowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class WindowStartEnd
implements UDTF {
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) {
        configurations.setOutputDataType(Type.INT64);
        if ("size".equals(parameters.getString("access"))) {
            configurations.setAccessStrategy((AccessStrategy)(parameters.hasAttribute("slidingStep") ? new SlidingSizeWindowAccessStrategy(parameters.getInt("windowSize").intValue(), parameters.getInt("slidingStep").intValue()) : new SlidingSizeWindowAccessStrategy(parameters.getInt("windowSize").intValue())));
        } else if ("time".equals(parameters.getString("access"))) {
            configurations.setAccessStrategy((AccessStrategy)(parameters.hasAttribute("slidingStep") && parameters.hasAttribute("displayWindowBegin") && parameters.hasAttribute("displayWindowEnd") ? new SlidingTimeWindowAccessStrategy(parameters.getLong("timeInterval").longValue(), parameters.getLong("slidingStep").longValue(), parameters.getLong("displayWindowBegin").longValue(), parameters.getLong("displayWindowEnd").longValue()) : new SlidingTimeWindowAccessStrategy(parameters.getLong("timeInterval").longValue())));
        } else if ("session".equals(parameters.getString("access"))) {
            configurations.setAccessStrategy((AccessStrategy)(parameters.hasAttribute("sessionGap") && parameters.hasAttribute("displayWindowBegin") && parameters.hasAttribute("displayWindowEnd") ? new SessionTimeWindowAccessStrategy(parameters.getLong("displayWindowBegin").longValue(), parameters.getLong("displayWindowEnd").longValue(), parameters.getLong("sessionGap").longValue()) : new SessionTimeWindowAccessStrategy(parameters.getLong("sessionGap").longValue())));
        } else if ("state".equals(parameters.getString("access"))) {
            if (parameters.hasAttribute("displayWindowBegin") && parameters.hasAttribute("displayWindowEnd")) {
                if (parameters.hasAttribute("delta")) {
                    configurations.setAccessStrategy((AccessStrategy)new StateWindowAccessStrategy(parameters.getLong("displayWindowBegin").longValue(), parameters.getLong("displayWindowEnd").longValue(), (double)parameters.getLong("delta").longValue()));
                } else {
                    configurations.setAccessStrategy((AccessStrategy)new StateWindowAccessStrategy(parameters.getLong("displayWindowBegin").longValue(), parameters.getLong("displayWindowEnd").longValue()));
                }
            } else if (parameters.hasAttribute("delta")) {
                configurations.setAccessStrategy((AccessStrategy)new StateWindowAccessStrategy((double)parameters.getLong("delta").longValue()));
            } else {
                configurations.setAccessStrategy((AccessStrategy)new StateWindowAccessStrategy());
            }
        }
    }

    public void transform(RowWindow rowWindow, PointCollector collector) throws IOException {
        collector.putLong(rowWindow.windowStartTime(), rowWindow.windowEndTime());
    }
}

