/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.example.relational;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.udf.api.exception.UDFArgumentNotValidException;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.relational.TableFunction;
import org.apache.iotdb.udf.api.relational.access.Record;
import org.apache.iotdb.udf.api.relational.table.TableFunctionAnalysis;
import org.apache.iotdb.udf.api.relational.table.TableFunctionProcessorProvider;
import org.apache.iotdb.udf.api.relational.table.argument.Argument;
import org.apache.iotdb.udf.api.relational.table.argument.ScalarArgument;
import org.apache.iotdb.udf.api.relational.table.processor.TableFunctionDataProcessor;
import org.apache.iotdb.udf.api.relational.table.specification.ParameterSpecification;
import org.apache.iotdb.udf.api.relational.table.specification.ScalarParameterSpecification;
import org.apache.iotdb.udf.api.relational.table.specification.TableParameterSpecification;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.block.column.ColumnBuilder;

public class MyRepeatWithoutIndex
implements TableFunction {
    private final String TBL_PARAM = "DATA";
    private final String N_PARAM = "N";

    public List<ParameterSpecification> getArgumentsSpecifications() {
        return Arrays.asList(TableParameterSpecification.builder().name("DATA").rowSemantics().passThroughColumns().build(), ScalarParameterSpecification.builder().name("N").type(Type.INT32).build());
    }

    public TableFunctionAnalysis analyze(Map<String, Argument> arguments) throws UDFException {
        ScalarArgument count = (ScalarArgument)arguments.get("N");
        if (count == null) {
            throw new UDFArgumentNotValidException("count argument for function repeat() is missing");
        }
        if ((Integer)count.getValue() <= 0) {
            throw new UDFArgumentNotValidException("count argument for function repeat() must be positive");
        }
        return TableFunctionAnalysis.builder().requiredColumns("DATA", Collections.singletonList(0)).build();
    }

    public TableFunctionProcessorProvider getProcessorProvider(Map<String, Argument> arguments) {
        final ScalarArgument count = (ScalarArgument)arguments.get("N");
        return new TableFunctionProcessorProvider(){

            public TableFunctionDataProcessor getDataProcessor() {
                return new TableFunctionDataProcessor(){
                    private final int n;
                    private long recordIndex;
                    {
                        this.n = (Integer)count.getValue();
                        this.recordIndex = 0L;
                    }

                    public void process(Record input, List<ColumnBuilder> properColumnBuilders, ColumnBuilder passThroughIndexBuilder) {
                        for (int i = 0; i < this.n; ++i) {
                            passThroughIndexBuilder.writeLong(this.recordIndex);
                        }
                        ++this.recordIndex;
                    }
                };
            }
        };
    }
}

