/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.it.env.cluster.node;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.it.env.cluster.EnvUtils;
import org.apache.iotdb.it.env.cluster.config.MppJVMConfig;
import org.apache.iotdb.it.env.cluster.node.AbstractNodeWrapper;

public class DataNodeWrapper
extends AbstractNodeWrapper {
    private int mppDataExchangePort;
    private int internalPort;
    private final String internalAddress = super.getIp();
    private final int dataRegionConsensusPort;
    private final int schemaRegionConsensusPort;
    private final int mqttPort;
    private final int restServicePort;
    private final int pipeAirGapReceiverPort;
    private final String defaultNodePropertiesFile;
    private final String defaultCommonPropertiesFile;

    public DataNodeWrapper(String seedConfigNode, String testClassName, String testMethodName, int[] portList, int clusterIndex, boolean isMultiCluster, long startTime) {
        super(testClassName, testMethodName, portList, clusterIndex, isMultiCluster, startTime);
        this.mppDataExchangePort = portList[1];
        this.internalPort = portList[2];
        this.dataRegionConsensusPort = portList[3];
        this.schemaRegionConsensusPort = portList[4];
        this.mqttPort = portList[5];
        this.pipeAirGapReceiverPort = portList[6];
        this.restServicePort = portList[10] + 6000;
        this.defaultNodePropertiesFile = EnvUtils.getFilePathFromSysVar("DefaultDataNodeProperties", clusterIndex);
        this.defaultCommonPropertiesFile = EnvUtils.getFilePathFromSysVar("DefaultDataNodeCommonProperties", clusterIndex);
        this.reloadMutableFields();
        this.immutableCommonProperties.setProperty("mqtt_host", super.getIp());
        this.immutableCommonProperties.setProperty("mqtt_port", String.valueOf(this.mqttPort));
        this.immutableCommonProperties.setProperty("pipe_air_gap_receiver_port", String.valueOf(this.pipeAirGapReceiverPort));
        this.immutableNodeProperties.setProperty("rest_service_port", String.valueOf(this.restServicePort));
        this.immutableNodeProperties.setProperty("dn_seed_config_node", seedConfigNode);
        this.immutableNodeProperties.setProperty("dn_system_dir", "");
        this.immutableNodeProperties.setProperty("dn_data_dirs", "");
        this.immutableNodeProperties.setProperty("dn_consensus_dir", "");
        this.immutableNodeProperties.setProperty("dn_wal_dirs", "");
        this.immutableNodeProperties.setProperty("dn_tracing_dir", "");
        this.immutableNodeProperties.setProperty("dn_sync_dir", "");
        this.immutableNodeProperties.setProperty("dn_metric_iotdb_reporter_host", "");
    }

    @Override
    protected String getSystemConfigPath() {
        return this.workDirFilePath("conf", "iotdb-system.properties");
    }

    @Override
    protected String getDefaultNodeConfigPath() {
        return this.defaultNodePropertiesFile;
    }

    @Override
    protected String getDefaultCommonConfigPath() {
        return this.defaultCommonPropertiesFile;
    }

    @Override
    public String getSystemPropertiesPath() {
        return this.workDirFilePath("data/datanode/system/schema", "system.properties");
    }

    @Override
    protected MppJVMConfig initVMConfig() {
        return MppJVMConfig.builder().setInitHeapSize(EnvUtils.getIntFromSysVar("DataNodeInitHeapSize", 256, this.clusterIndex)).setMaxHeapSize(EnvUtils.getIntFromSysVar("DataNodeMaxHeapSize", 256, this.clusterIndex)).setMaxDirectMemorySize(EnvUtils.getIntFromSysVar("DataNodeMaxDirectMemorySize", 256, this.clusterIndex)).build();
    }

    @Override
    public final String getId() {
        return "DataNode" + this.getPort();
    }

    @Override
    protected void addStartCmdParams(List<String> params) {
        String workDir = this.getNodePath();
        String confDir = workDir + File.separator + "conf";
        params.addAll(Arrays.asList("-Dlogback.configurationFile=" + confDir + File.separator + "logback-datanode.xml", "-DIOTDB_HOME=" + workDir, "-DTSFILE_HOME=" + workDir, "-DIOTDB_CONF=" + confDir, "-DTSFILE_CONF=" + confDir, "org.apache.iotdb.db.service.DataNode", "-s"));
    }

    @Override
    String getNodeType() {
        return "datanode";
    }

    @Override
    protected void reloadMutableFields() {
        this.mutableCommonProperties.setProperty("config_node_consensus_protocol_class", "org.apache.iotdb.consensus.simple.SimpleConsensus");
        this.mutableCommonProperties.setProperty("schema_region_consensus_protocol_class", "org.apache.iotdb.consensus.simple.SimpleConsensus");
        this.mutableCommonProperties.setProperty("data_region_consensus_protocol_class", "org.apache.iotdb.consensus.simple.SimpleConsensus");
        this.mutableCommonProperties.setProperty("schema_replication_factor", "1");
        this.mutableCommonProperties.setProperty("data_replication_factor", "1");
        this.mutableNodeProperties.put("rest_service_port", String.valueOf(this.restServicePort));
        this.mutableCommonProperties.put("max_tsblock_size_in_bytes", "1024");
        this.mutableCommonProperties.put("page_size_in_byte", "1024");
        this.mutableNodeProperties.put("dn_join_cluster_retry_interval_ms", "1000");
        this.mutableNodeProperties.put("dn_connection_timeout_ms", "30000");
        this.mutableNodeProperties.put("dn_metric_internal_reporter_type", "MEMORY");
        this.mutableNodeProperties.setProperty("dn_rpc_address", super.getIp());
        this.mutableNodeProperties.setProperty("dn_rpc_port", String.valueOf(super.getPort()));
        this.mutableNodeProperties.setProperty("dn_internal_address", this.internalAddress);
        this.mutableNodeProperties.setProperty("dn_metric_prometheus_reporter_port", String.valueOf(super.getMetricPort()));
        this.mutableNodeProperties.setProperty("dn_internal_port", String.valueOf(this.internalPort));
        this.mutableNodeProperties.setProperty("dn_mpp_data_exchange_port", String.valueOf(this.mppDataExchangePort));
        this.mutableNodeProperties.setProperty("dn_data_region_consensus_port", String.valueOf(this.dataRegionConsensusPort));
        this.mutableNodeProperties.setProperty("dn_schema_region_consensus_port", String.valueOf(this.schemaRegionConsensusPort));
        this.mutableNodeProperties.setProperty("wal_buffer_size_in_byte", "16777216");
        this.mutableNodeProperties.setProperty("schema_region_ratis_log_appender_buffer_size_max", "8388608");
        this.mutableNodeProperties.setProperty("data_region_ratis_log_appender_buffer_size_max", "8388608");
    }

    @Override
    public void renameFile() {
        String oldLogFilePath = this.getLogDirPath() + File.separator + "DataNode" + this.portList[0] + ".log";
        String newLogFilePath = this.getLogDirPath() + File.separator + this.getId() + ".log";
        File oldLogFile = new File(oldLogFilePath);
        oldLogFile.renameTo(new File(newLogFilePath));
        String oldNodeDirPath = System.getProperty("user.dir") + File.separator + "target" + File.separator + "DataNode" + this.portList[0];
        String newNodeDirPath = this.getNodePath();
        File oldNodeDir = new File(oldNodeDirPath);
        oldNodeDir.renameTo(new File(newNodeDirPath));
    }

    public int getMppDataExchangePort() {
        return this.mppDataExchangePort;
    }

    public void setMppDataExchangePort(int mppDataExchangePort) {
        this.mppDataExchangePort = mppDataExchangePort;
    }

    public String getInternalAddress() {
        return this.internalAddress;
    }

    public int getInternalPort() {
        return this.internalPort;
    }

    public void setInternalPort(int internalPort) {
        this.internalPort = internalPort;
    }

    public int getDataRegionConsensusPort() {
        return this.dataRegionConsensusPort;
    }

    public int getSchemaRegionConsensusPort() {
        return this.schemaRegionConsensusPort;
    }

    public int getMqttPort() {
        return this.mqttPort;
    }

    public int getPipeAirGapReceiverPort() {
        return this.pipeAirGapReceiverPort;
    }

    public int getRestServicePort() {
        return this.restServicePort;
    }
}

