/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.it.env.cluster.config;

import java.util.concurrent.TimeUnit;
import org.apache.iotdb.it.env.cluster.config.MppCommonConfig;
import org.apache.iotdb.itbase.env.CommonConfig;

public class MppSharedCommonConfig
implements CommonConfig {
    private final MppCommonConfig cnConfig;
    private final MppCommonConfig dnConfig;

    public MppSharedCommonConfig(MppCommonConfig cnConfig, MppCommonConfig dnConfig) {
        this.cnConfig = cnConfig;
        this.dnConfig = dnConfig;
    }

    @Override
    public CommonConfig setMaxNumberOfPointsInPage(int maxNumberOfPointsInPage) {
        this.cnConfig.setMaxNumberOfPointsInPage(maxNumberOfPointsInPage);
        this.dnConfig.setMaxNumberOfPointsInPage(maxNumberOfPointsInPage);
        return this;
    }

    @Override
    public CommonConfig setPageSizeInByte(int pageSizeInByte) {
        this.cnConfig.setPageSizeInByte(pageSizeInByte);
        this.dnConfig.setPageSizeInByte(pageSizeInByte);
        return this;
    }

    @Override
    public CommonConfig setGroupSizeInByte(int groupSizeInByte) {
        this.cnConfig.setGroupSizeInByte(groupSizeInByte);
        this.dnConfig.setGroupSizeInByte(groupSizeInByte);
        return this;
    }

    @Override
    public CommonConfig setMemtableSizeThreshold(long memtableSizeThreshold) {
        this.cnConfig.setMemtableSizeThreshold(memtableSizeThreshold);
        this.dnConfig.setMemtableSizeThreshold(memtableSizeThreshold);
        return this;
    }

    @Override
    public CommonConfig setPartitionInterval(long partitionInterval) {
        this.cnConfig.setPartitionInterval(partitionInterval);
        this.dnConfig.setPartitionInterval(partitionInterval);
        return this;
    }

    @Override
    public CommonConfig setCompressor(String compressor) {
        this.cnConfig.setCompressor(compressor);
        this.dnConfig.setCompressor(compressor);
        return this;
    }

    @Override
    public CommonConfig setConfigRegionRatisRPCLeaderElectionTimeoutMaxMs(int maxMs) {
        this.cnConfig.setConfigRegionRatisRPCLeaderElectionTimeoutMaxMs(maxMs);
        this.dnConfig.setConfigRegionRatisRPCLeaderElectionTimeoutMaxMs(maxMs);
        return this;
    }

    @Override
    public CommonConfig setUdfMemoryBudgetInMB(float udfCollectorMemoryBudgetInMB) {
        this.cnConfig.setUdfMemoryBudgetInMB(udfCollectorMemoryBudgetInMB);
        this.dnConfig.setUdfMemoryBudgetInMB(udfCollectorMemoryBudgetInMB);
        return this;
    }

    @Override
    public CommonConfig setEnableSeqSpaceCompaction(boolean enableSeqSpaceCompaction) {
        this.cnConfig.setEnableSeqSpaceCompaction(enableSeqSpaceCompaction);
        this.dnConfig.setEnableSeqSpaceCompaction(enableSeqSpaceCompaction);
        return this;
    }

    @Override
    public CommonConfig setEnableUnseqSpaceCompaction(boolean enableUnseqSpaceCompaction) {
        this.cnConfig.setEnableUnseqSpaceCompaction(enableUnseqSpaceCompaction);
        this.dnConfig.setEnableUnseqSpaceCompaction(enableUnseqSpaceCompaction);
        return this;
    }

    @Override
    public CommonConfig setEnableMemControl(boolean enableMemControl) {
        this.cnConfig.setEnableMemControl(enableMemControl);
        this.dnConfig.setEnableMemControl(enableMemControl);
        return this;
    }

    @Override
    public CommonConfig setEnableCrossSpaceCompaction(boolean enableCrossSpaceCompaction) {
        this.cnConfig.setEnableCrossSpaceCompaction(enableCrossSpaceCompaction);
        this.dnConfig.setEnableCrossSpaceCompaction(enableCrossSpaceCompaction);
        return this;
    }

    @Override
    public CommonConfig setInnerCompactionCandidateFileNum(int maxInnerCompactionCandidateFileNum) {
        this.cnConfig.setInnerCompactionCandidateFileNum(maxInnerCompactionCandidateFileNum);
        this.dnConfig.setInnerCompactionCandidateFileNum(maxInnerCompactionCandidateFileNum);
        return this;
    }

    @Override
    public CommonConfig setAutoCreateSchemaEnabled(boolean enableAutoCreateSchema) {
        this.cnConfig.setAutoCreateSchemaEnabled(enableAutoCreateSchema);
        this.dnConfig.setAutoCreateSchemaEnabled(enableAutoCreateSchema);
        return this;
    }

    @Override
    public CommonConfig setEnableLastCache(boolean lastCacheEnable) {
        this.cnConfig.setEnableLastCache(lastCacheEnable);
        this.dnConfig.setEnableLastCache(lastCacheEnable);
        return this;
    }

    @Override
    public CommonConfig setPrimitiveArraySize(int primitiveArraySize) {
        this.cnConfig.setPrimitiveArraySize(primitiveArraySize);
        this.dnConfig.setPrimitiveArraySize(primitiveArraySize);
        return this;
    }

    @Override
    public CommonConfig setTargetChunkPointNum(int targetChunkPointNum) {
        this.cnConfig.setTargetChunkPointNum(targetChunkPointNum);
        this.dnConfig.setTargetChunkPointNum(targetChunkPointNum);
        return this;
    }

    @Override
    public CommonConfig setMaxTsBlockLineNumber(int maxTsBlockLineNumber) {
        this.cnConfig.setMaxTsBlockLineNumber(maxTsBlockLineNumber);
        this.dnConfig.setMaxTsBlockLineNumber(maxTsBlockLineNumber);
        return this;
    }

    @Override
    public CommonConfig setConfigNodeConsensusProtocolClass(String configNodeConsensusProtocolClass) {
        this.cnConfig.setConfigNodeConsensusProtocolClass(configNodeConsensusProtocolClass);
        this.dnConfig.setConfigNodeConsensusProtocolClass(configNodeConsensusProtocolClass);
        return this;
    }

    @Override
    public CommonConfig setSchemaRegionConsensusProtocolClass(String schemaRegionConsensusProtocolClass) {
        this.cnConfig.setSchemaRegionConsensusProtocolClass(schemaRegionConsensusProtocolClass);
        this.dnConfig.setSchemaRegionConsensusProtocolClass(schemaRegionConsensusProtocolClass);
        return this;
    }

    @Override
    public CommonConfig setDataRegionConsensusProtocolClass(String dataRegionConsensusProtocolClass) {
        this.cnConfig.setDataRegionConsensusProtocolClass(dataRegionConsensusProtocolClass);
        this.dnConfig.setDataRegionConsensusProtocolClass(dataRegionConsensusProtocolClass);
        return this;
    }

    @Override
    public CommonConfig setSchemaRegionGroupExtensionPolicy(String schemaRegionGroupExtensionPolicy) {
        this.cnConfig.setSchemaRegionGroupExtensionPolicy(schemaRegionGroupExtensionPolicy);
        this.dnConfig.setSchemaRegionGroupExtensionPolicy(schemaRegionGroupExtensionPolicy);
        return this;
    }

    @Override
    public CommonConfig setDefaultSchemaRegionGroupNumPerDatabase(int schemaRegionGroupPerDatabase) {
        this.cnConfig.setDefaultSchemaRegionGroupNumPerDatabase(schemaRegionGroupPerDatabase);
        this.dnConfig.setDefaultSchemaRegionGroupNumPerDatabase(schemaRegionGroupPerDatabase);
        return this;
    }

    @Override
    public CommonConfig setDataRegionGroupExtensionPolicy(String dataRegionGroupExtensionPolicy) {
        this.cnConfig.setDataRegionGroupExtensionPolicy(dataRegionGroupExtensionPolicy);
        this.dnConfig.setDataRegionGroupExtensionPolicy(dataRegionGroupExtensionPolicy);
        return this;
    }

    @Override
    public CommonConfig setDefaultDataRegionGroupNumPerDatabase(int dataRegionGroupPerDatabase) {
        this.cnConfig.setDefaultDataRegionGroupNumPerDatabase(dataRegionGroupPerDatabase);
        this.dnConfig.setDefaultDataRegionGroupNumPerDatabase(dataRegionGroupPerDatabase);
        return this;
    }

    @Override
    public CommonConfig setSchemaReplicationFactor(int schemaReplicationFactor) {
        this.cnConfig.setSchemaReplicationFactor(schemaReplicationFactor);
        this.dnConfig.setSchemaReplicationFactor(schemaReplicationFactor);
        return this;
    }

    @Override
    public CommonConfig setDataReplicationFactor(int dataReplicationFactor) {
        this.cnConfig.setDataReplicationFactor(dataReplicationFactor);
        this.dnConfig.setDataReplicationFactor(dataReplicationFactor);
        return this;
    }

    @Override
    public CommonConfig setTimePartitionInterval(long timePartitionInterval) {
        this.cnConfig.setTimePartitionInterval(timePartitionInterval);
        this.dnConfig.setTimePartitionInterval(timePartitionInterval);
        return this;
    }

    @Override
    public CommonConfig setTTLCheckInterval(long ttlCheckInterval) {
        this.cnConfig.setTTLCheckInterval(ttlCheckInterval);
        this.dnConfig.setTTLCheckInterval(ttlCheckInterval);
        return this;
    }

    @Override
    public CommonConfig setTimePartitionOrigin(long timePartitionOrigin) {
        this.cnConfig.setTimePartitionOrigin(timePartitionOrigin);
        this.dnConfig.setTimePartitionOrigin(timePartitionOrigin);
        return this;
    }

    @Override
    public CommonConfig setTimestampPrecision(String timestampPrecision) {
        this.cnConfig.setTimestampPrecision(timestampPrecision);
        this.dnConfig.setTimestampPrecision(timestampPrecision);
        return this;
    }

    @Override
    public TimeUnit getTimestampPrecision() {
        String precision;
        switch (precision = this.dnConfig.properties.getProperty("timestamp_precision", "ms")) {
            case "ms": {
                return TimeUnit.MILLISECONDS;
            }
            case "us": {
                return TimeUnit.MICROSECONDS;
            }
            case "ns": {
                return TimeUnit.NANOSECONDS;
            }
        }
        throw new UnsupportedOperationException(precision);
    }

    @Override
    public CommonConfig setTimestampPrecisionCheckEnabled(boolean timestampPrecisionCheckEnabled) {
        this.cnConfig.setTimestampPrecisionCheckEnabled(timestampPrecisionCheckEnabled);
        this.dnConfig.setTimestampPrecisionCheckEnabled(timestampPrecisionCheckEnabled);
        return this;
    }

    @Override
    public CommonConfig setConfigNodeRatisSnapshotTriggerThreshold(int ratisSnapshotTriggerThreshold) {
        this.cnConfig.setConfigNodeRatisSnapshotTriggerThreshold(ratisSnapshotTriggerThreshold);
        this.dnConfig.setConfigNodeRatisSnapshotTriggerThreshold(ratisSnapshotTriggerThreshold);
        return this;
    }

    @Override
    public CommonConfig setMaxDegreeOfIndexNode(int maxDegreeOfIndexNode) {
        this.cnConfig.setMaxDegreeOfIndexNode(maxDegreeOfIndexNode);
        this.dnConfig.setMaxDegreeOfIndexNode(maxDegreeOfIndexNode);
        return this;
    }

    @Override
    public CommonConfig setEnableMQTTService(boolean enableMQTTService) {
        this.cnConfig.setEnableMQTTService(enableMQTTService);
        this.dnConfig.setEnableMQTTService(enableMQTTService);
        return this;
    }

    @Override
    public CommonConfig setSchemaEngineMode(String schemaEngineMode) {
        this.cnConfig.setSchemaEngineMode(schemaEngineMode);
        this.dnConfig.setSchemaEngineMode(schemaEngineMode);
        return this;
    }

    @Override
    public CommonConfig setSelectIntoInsertTabletPlanRowLimit(int selectIntoInsertTabletPlanRowLimit) {
        this.cnConfig.setSelectIntoInsertTabletPlanRowLimit(selectIntoInsertTabletPlanRowLimit);
        this.dnConfig.setSelectIntoInsertTabletPlanRowLimit(selectIntoInsertTabletPlanRowLimit);
        return this;
    }

    @Override
    public CommonConfig setEnableAutoLeaderBalanceForRatisConsensus(boolean enableAutoLeaderBalanceForRatisConsensus) {
        this.cnConfig.setEnableAutoLeaderBalanceForRatisConsensus(enableAutoLeaderBalanceForRatisConsensus);
        this.dnConfig.setEnableAutoLeaderBalanceForRatisConsensus(enableAutoLeaderBalanceForRatisConsensus);
        return this;
    }

    @Override
    public CommonConfig setEnableAutoLeaderBalanceForIoTConsensus(boolean enableAutoLeaderBalanceForIoTConsensus) {
        this.cnConfig.setEnableAutoLeaderBalanceForIoTConsensus(enableAutoLeaderBalanceForIoTConsensus);
        this.dnConfig.setEnableAutoLeaderBalanceForIoTConsensus(enableAutoLeaderBalanceForIoTConsensus);
        return this;
    }

    @Override
    public CommonConfig setQueryThreadCount(int queryThreadCount) {
        this.cnConfig.setQueryThreadCount(queryThreadCount);
        this.dnConfig.setQueryThreadCount(queryThreadCount);
        return this;
    }

    @Override
    public CommonConfig setWalBufferSize(int walBufferSize) {
        this.cnConfig.setWalBufferSize(walBufferSize);
        this.dnConfig.setWalBufferSize(walBufferSize);
        return this;
    }

    @Override
    public CommonConfig setDegreeOfParallelism(int degreeOfParallelism) {
        this.cnConfig.setDegreeOfParallelism(degreeOfParallelism);
        this.dnConfig.setDegreeOfParallelism(degreeOfParallelism);
        return this;
    }

    @Override
    public CommonConfig setDataRatisTriggerSnapshotThreshold(long threshold) {
        this.cnConfig.setDataRatisTriggerSnapshotThreshold(threshold);
        this.dnConfig.setDataRatisTriggerSnapshotThreshold(threshold);
        return this;
    }

    @Override
    public CommonConfig setSeriesSlotNum(int seriesSlotNum) {
        this.cnConfig.setSeriesSlotNum(seriesSlotNum);
        this.dnConfig.setSeriesSlotNum(seriesSlotNum);
        return this;
    }

    @Override
    public CommonConfig setDataPartitionAllocationStrategy(String dataPartitionAllocationStrategy) {
        this.cnConfig.setDataPartitionAllocationStrategy(dataPartitionAllocationStrategy);
        return this;
    }

    @Override
    public CommonConfig setSeriesPartitionExecutorClass(String seriesPartitionExecutorClass) {
        this.cnConfig.setSeriesPartitionExecutorClass(seriesPartitionExecutorClass);
        this.dnConfig.setSeriesPartitionExecutorClass(seriesPartitionExecutorClass);
        return this;
    }

    @Override
    public CommonConfig setSchemaMemoryAllocate(String schemaMemoryAllocate) {
        this.dnConfig.setSchemaMemoryAllocate(schemaMemoryAllocate);
        this.cnConfig.setSchemaMemoryAllocate(schemaMemoryAllocate);
        return this;
    }

    @Override
    public CommonConfig setWriteMemoryProportion(String writeMemoryProportion) {
        this.dnConfig.setWriteMemoryProportion(writeMemoryProportion);
        this.cnConfig.setWriteMemoryProportion(writeMemoryProportion);
        return this;
    }

    @Override
    public CommonConfig setQuotaEnable(boolean quotaEnable) {
        this.dnConfig.setQuotaEnable(quotaEnable);
        this.cnConfig.setQuotaEnable(quotaEnable);
        return this;
    }

    @Override
    public CommonConfig setSortBufferSize(long sortBufferSize) {
        this.dnConfig.setSortBufferSize(sortBufferSize);
        this.cnConfig.setSortBufferSize(sortBufferSize);
        return this;
    }

    @Override
    public CommonConfig setMaxTsBlockSizeInByte(long maxTsBlockSizeInByte) {
        this.dnConfig.setMaxTsBlockSizeInByte(maxTsBlockSizeInByte);
        this.cnConfig.setMaxTsBlockSizeInByte(maxTsBlockSizeInByte);
        return this;
    }

    @Override
    public CommonConfig setClusterTimeseriesLimitThreshold(long clusterSchemaLimitThreshold) {
        this.dnConfig.setClusterTimeseriesLimitThreshold(clusterSchemaLimitThreshold);
        this.cnConfig.setClusterTimeseriesLimitThreshold(clusterSchemaLimitThreshold);
        return this;
    }

    @Override
    public CommonConfig setClusterDeviceLimitThreshold(long clusterDeviceLimitThreshold) {
        this.dnConfig.setClusterDeviceLimitThreshold(clusterDeviceLimitThreshold);
        this.cnConfig.setClusterDeviceLimitThreshold(clusterDeviceLimitThreshold);
        return this;
    }

    @Override
    public CommonConfig setDatabaseLimitThreshold(long databaseLimitThreshold) {
        this.dnConfig.setDatabaseLimitThreshold(databaseLimitThreshold);
        this.cnConfig.setDatabaseLimitThreshold(databaseLimitThreshold);
        return this;
    }

    @Override
    public CommonConfig setDataRegionPerDataNode(double dataRegionPerDataNode) {
        this.dnConfig.setDataRegionPerDataNode(dataRegionPerDataNode);
        this.cnConfig.setDataRegionPerDataNode(dataRegionPerDataNode);
        return this;
    }

    @Override
    public CommonConfig setSchemaRegionPerDataNode(double schemaRegionPerDataNode) {
        this.dnConfig.setSchemaRegionPerDataNode(schemaRegionPerDataNode);
        this.cnConfig.setSchemaRegionPerDataNode(schemaRegionPerDataNode);
        return this;
    }

    @Override
    public CommonConfig setPipeMemoryManagementEnabled(boolean pipeMemoryManagementEnabled) {
        this.dnConfig.setPipeMemoryManagementEnabled(pipeMemoryManagementEnabled);
        this.cnConfig.setPipeMemoryManagementEnabled(pipeMemoryManagementEnabled);
        return this;
    }

    @Override
    public CommonConfig setIsPipeEnableMemoryCheck(boolean isPipeEnableMemoryCheck) {
        this.dnConfig.setIsPipeEnableMemoryCheck(isPipeEnableMemoryCheck);
        this.cnConfig.setIsPipeEnableMemoryCheck(isPipeEnableMemoryCheck);
        return this;
    }

    @Override
    public CommonConfig setPipeAirGapReceiverEnabled(boolean isPipeAirGapReceiverEnabled) {
        this.dnConfig.setPipeAirGapReceiverEnabled(isPipeAirGapReceiverEnabled);
        this.cnConfig.setPipeAirGapReceiverEnabled(isPipeAirGapReceiverEnabled);
        return this;
    }

    @Override
    public CommonConfig setDriverTaskExecutionTimeSliceInMs(long driverTaskExecutionTimeSliceInMs) {
        this.dnConfig.setDriverTaskExecutionTimeSliceInMs(driverTaskExecutionTimeSliceInMs);
        this.cnConfig.setDriverTaskExecutionTimeSliceInMs(driverTaskExecutionTimeSliceInMs);
        return this;
    }

    @Override
    public CommonConfig setWalMode(String walMode) {
        this.dnConfig.setWalMode(walMode);
        this.cnConfig.setWalMode(walMode);
        return this;
    }

    @Override
    public CommonConfig setTagAttributeTotalSize(int tagAttributeTotalSize) {
        this.dnConfig.setTagAttributeTotalSize(tagAttributeTotalSize);
        this.cnConfig.setTagAttributeTotalSize(tagAttributeTotalSize);
        return this;
    }

    @Override
    public CommonConfig setDnConnectionTimeoutMs(int connectionTimeoutMs) {
        this.dnConfig.setDnConnectionTimeoutMs(connectionTimeoutMs);
        this.cnConfig.setDnConnectionTimeoutMs(connectionTimeoutMs);
        return this;
    }

    @Override
    public CommonConfig setPipeHeartbeatIntervalSecondsForCollectingPipeMeta(int pipeHeartbeatIntervalSecondsForCollectingPipeMeta) {
        this.dnConfig.setPipeHeartbeatIntervalSecondsForCollectingPipeMeta(pipeHeartbeatIntervalSecondsForCollectingPipeMeta);
        this.cnConfig.setPipeHeartbeatIntervalSecondsForCollectingPipeMeta(pipeHeartbeatIntervalSecondsForCollectingPipeMeta);
        return this;
    }

    @Override
    public CommonConfig setPipeMetaSyncerInitialSyncDelayMinutes(long pipeMetaSyncerInitialSyncDelayMinutes) {
        this.dnConfig.setPipeMetaSyncerInitialSyncDelayMinutes(pipeMetaSyncerInitialSyncDelayMinutes);
        this.cnConfig.setPipeMetaSyncerInitialSyncDelayMinutes(pipeMetaSyncerInitialSyncDelayMinutes);
        return this;
    }

    @Override
    public CommonConfig setPipeMetaSyncerSyncIntervalMinutes(long pipeMetaSyncerSyncIntervalMinutes) {
        this.dnConfig.setPipeMetaSyncerSyncIntervalMinutes(pipeMetaSyncerSyncIntervalMinutes);
        this.cnConfig.setPipeMetaSyncerSyncIntervalMinutes(pipeMetaSyncerSyncIntervalMinutes);
        return this;
    }

    @Override
    public CommonConfig setPipeConnectorRequestSliceThresholdBytes(int pipeConnectorRequestSliceThresholdBytes) {
        this.dnConfig.setPipeConnectorRequestSliceThresholdBytes(pipeConnectorRequestSliceThresholdBytes);
        this.cnConfig.setPipeConnectorRequestSliceThresholdBytes(pipeConnectorRequestSliceThresholdBytes);
        return this;
    }

    @Override
    public CommonConfig setPipeAutoSplitFullEnabled(boolean pipeAutoSplitFullEnabled) {
        this.dnConfig.setPipeAutoSplitFullEnabled(pipeAutoSplitFullEnabled);
        this.cnConfig.setPipeAutoSplitFullEnabled(pipeAutoSplitFullEnabled);
        return this;
    }

    @Override
    public CommonConfig setQueryMemoryProportion(String queryMemoryProportion) {
        this.dnConfig.setQueryMemoryProportion(queryMemoryProportion);
        this.cnConfig.setQueryMemoryProportion(queryMemoryProportion);
        return this;
    }

    @Override
    public CommonConfig setSubscriptionPrefetchTsFileBatchMaxDelayInMs(int subscriptionPrefetchTsFileBatchMaxDelayInMs) {
        this.dnConfig.setSubscriptionPrefetchTsFileBatchMaxDelayInMs(subscriptionPrefetchTsFileBatchMaxDelayInMs);
        this.cnConfig.setSubscriptionPrefetchTsFileBatchMaxDelayInMs(subscriptionPrefetchTsFileBatchMaxDelayInMs);
        return this;
    }

    @Override
    public CommonConfig setSubscriptionPrefetchTsFileBatchMaxSizeInBytes(int subscriptionPrefetchTsFileBatchMaxSizeInBytes) {
        this.dnConfig.setSubscriptionPrefetchTsFileBatchMaxSizeInBytes(subscriptionPrefetchTsFileBatchMaxSizeInBytes);
        this.cnConfig.setSubscriptionPrefetchTsFileBatchMaxSizeInBytes(subscriptionPrefetchTsFileBatchMaxSizeInBytes);
        return this;
    }

    @Override
    public CommonConfig setSubscriptionEnabled(boolean subscriptionEnabled) {
        this.dnConfig.setSubscriptionEnabled(subscriptionEnabled);
        this.cnConfig.setSubscriptionEnabled(subscriptionEnabled);
        return this;
    }

    @Override
    public CommonConfig setDefaultStorageGroupLevel(int defaultStorageGroupLevel) {
        this.dnConfig.setDefaultStorageGroupLevel(defaultStorageGroupLevel);
        this.cnConfig.setDefaultStorageGroupLevel(defaultStorageGroupLevel);
        return this;
    }

    @Override
    public CommonConfig setDatanodeMemoryProportion(String datanodeMemoryProportion) {
        this.dnConfig.setDatanodeMemoryProportion(datanodeMemoryProportion);
        this.cnConfig.setDatanodeMemoryProportion(datanodeMemoryProportion);
        return this;
    }
}

