/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.it.env.cluster.node;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.it.env.cluster.EnvUtils;
import org.apache.iotdb.it.env.cluster.config.MppJVMConfig;
import org.apache.iotdb.it.env.cluster.node.AbstractNodeWrapper;

public class ConfigNodeWrapper
extends AbstractNodeWrapper {
    private int consensusPort;
    private final boolean isSeed;
    private final String defaultNodePropertiesFile;
    private final String defaultCommonPropertiesFile;

    public ConfigNodeWrapper(boolean isSeed, String targetCNs, String testClassName, String testMethodName, int[] portList, int clusterIndex, boolean isMultiCluster, long startTime) {
        super(testClassName, testMethodName, portList, clusterIndex, isMultiCluster, startTime);
        this.consensusPort = portList[1];
        this.isSeed = isSeed;
        this.defaultNodePropertiesFile = EnvUtils.getFilePathFromSysVar("DefaultConfigNodeProperties", clusterIndex);
        this.defaultCommonPropertiesFile = EnvUtils.getFilePathFromSysVar("DefaultConfigNodeCommonProperties", clusterIndex);
        this.reloadMutableFields();
        this.immutableNodeProperties.setProperty("cn_seed_config_node", isSeed ? this.getIpAndPortString() : targetCNs);
        this.immutableNodeProperties.setProperty("cn_system_dir", "");
        this.immutableNodeProperties.setProperty("cn_consensus_dir", "");
        this.immutableNodeProperties.setProperty("cn_metric_iotdb_reporter_host", "");
    }

    @Override
    protected String getSystemConfigPath() {
        return this.workDirFilePath("conf", "iotdb-system.properties");
    }

    @Override
    protected String getDefaultNodeConfigPath() {
        return this.defaultNodePropertiesFile;
    }

    @Override
    protected String getDefaultCommonConfigPath() {
        return this.defaultCommonPropertiesFile;
    }

    @Override
    public String getSystemPropertiesPath() {
        return this.workDirFilePath("data/confignode/system", "confignode-system.properties");
    }

    @Override
    protected MppJVMConfig initVMConfig() {
        return MppJVMConfig.builder().setInitHeapSize(EnvUtils.getIntFromSysVar("ConfigNodeInitHeapSize", 256, this.clusterIndex)).setMaxHeapSize(EnvUtils.getIntFromSysVar("ConfigNodeMaxHeapSize", 256, this.clusterIndex)).setMaxDirectMemorySize(EnvUtils.getIntFromSysVar("ConfigNodeMaxDirectMemorySize", 256, this.clusterIndex)).setTimezone("Asia/Shanghai").build();
    }

    @Override
    public final String getId() {
        if (this.isSeed) {
            return "SeedConfigNode" + this.getPort();
        }
        return "ConfigNode" + this.getPort();
    }

    @Override
    protected void addStartCmdParams(List<String> params) {
        String workDir = this.getNodePath();
        String confDir = workDir + File.separator + "conf";
        params.addAll(Arrays.asList("-Dlogback.configurationFile=" + confDir + File.separator + "logback-confignode.xml", "-DCONFIGNODE_HOME=" + workDir, "-DCONFIGNODE_CONF=" + confDir, "-DIOTDB_HOME=" + workDir, "-DIOTDB_CONF=" + confDir, "-DTSFILE_CONF=" + confDir, "org.apache.iotdb.confignode.service.ConfigNode", "-s"));
    }

    @Override
    String getNodeType() {
        return "confignode";
    }

    @Override
    protected void reloadMutableFields() {
        this.mutableCommonProperties.setProperty("config_node_consensus_protocol_class", "org.apache.iotdb.consensus.simple.SimpleConsensus");
        this.mutableCommonProperties.setProperty("schema_region_consensus_protocol_class", "org.apache.iotdb.consensus.simple.SimpleConsensus");
        this.mutableCommonProperties.setProperty("data_region_consensus_protocol_class", "org.apache.iotdb.consensus.simple.SimpleConsensus");
        this.mutableCommonProperties.setProperty("schema_replication_factor", "1");
        this.mutableCommonProperties.setProperty("data_replication_factor", "1");
        this.mutableNodeProperties.put("cn_connection_timeout_ms", "30000");
        this.mutableNodeProperties.setProperty("cn_internal_address", super.getIp());
        this.mutableNodeProperties.setProperty("cn_internal_port", String.valueOf(this.getPort()));
        this.mutableNodeProperties.setProperty("cn_consensus_port", String.valueOf(this.consensusPort));
        this.mutableNodeProperties.setProperty("cn_metric_prometheus_reporter_port", String.valueOf(super.getMetricPort()));
        this.mutableNodeProperties.setProperty("config_node_ratis_log_appender_buffer_size_max", "8388608");
    }

    @Override
    protected void renameFile() {
        String configNodeName = this.isSeed ? "SeedConfigNode" : "ConfigNode";
        File oldLogFile = new File(this.getLogDirPath() + File.separator + configNodeName + this.portList[0] + ".log");
        oldLogFile.renameTo(new File(this.getLogDirPath() + File.separator + this.getId() + ".log"));
        File oldNodeDir = new File(System.getProperty("user.dir") + File.separator + "target" + File.separator + configNodeName + this.portList[0]);
        oldNodeDir.renameTo(new File(this.getNodePath()));
    }

    public void setConsensusPort(int consensusPort) {
        this.consensusPort = consensusPort;
    }

    public int getConsensusPort() {
        return this.consensusPort;
    }
}

