/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.iotdb.isession.template.Template;
import org.apache.iotdb.isession.template.TemplateNode;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.session.template.MeasurementNode;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionConcurrentExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionConcurrentExample.class);
    private static final int SG_NUM = 20;
    private static final int DEVICE_NUM = 100;
    private static final int PARALLEL_DEGREE_FOR_ONE_SG = 3;
    private static Random random = new Random();

    public static void main(String[] args) throws IoTDBConnectionException, StatementExecutionException, IOException {
        try (Session session = new Session("127.0.0.1", 6667, "root", "root");){
            session.open(false);
            SessionConcurrentExample.createTemplate(session);
        }
        catch (Exception e) {
            LOGGER.error("create template with Session error", (Throwable)e);
        }
        CountDownLatch latch = new CountDownLatch(60);
        ExecutorService es = Executors.newFixedThreadPool(60);
        int i = 0;
        while (i < 60) {
            int currentIndex = i++;
            es.execute(() -> SessionConcurrentExample.concurrentOperation(latch, currentIndex));
        }
        es.shutdown();
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            LOGGER.warn("CountDownLatch interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private static void concurrentOperation(CountDownLatch latch, int currentIndex) {
        Session session = new Session("127.0.0.1", 6667, "root", "root");
        try {
            session.open(false);
        }
        catch (IoTDBConnectionException e) {
            LOGGER.error("Open Session error", (Throwable)e);
        }
        for (int j = 0; j < 100; ++j) {
            try {
                SessionConcurrentExample.insertTablet(session, String.format("root.sg_%d.d_%d", currentIndex / 3, j));
                continue;
            }
            catch (IoTDBConnectionException | StatementExecutionException e) {
                LOGGER.error("Insert tablet error", e);
            }
        }
        try {
            session.close();
        }
        catch (IoTDBConnectionException e) {
            LOGGER.error("Close session error", (Throwable)e);
        }
        latch.countDown();
    }

    private static void createTemplate(Session session) throws IoTDBConnectionException, StatementExecutionException, IOException {
        Template template = new Template("template1", false);
        MeasurementNode mNodeS1 = new MeasurementNode("s1", TSDataType.INT64, TSEncoding.RLE, CompressionType.SNAPPY);
        MeasurementNode mNodeS2 = new MeasurementNode("s2", TSDataType.INT64, TSEncoding.RLE, CompressionType.SNAPPY);
        MeasurementNode mNodeS3 = new MeasurementNode("s3", TSDataType.INT64, TSEncoding.RLE, CompressionType.SNAPPY);
        template.addToTemplate((TemplateNode)mNodeS1);
        template.addToTemplate((TemplateNode)mNodeS2);
        template.addToTemplate((TemplateNode)mNodeS3);
        session.createSchemaTemplate(template);
        for (int i = 0; i < 20; ++i) {
            session.setSchemaTemplate("template1", "root.sg_" + i);
        }
    }

    private static void insertTablet(Session session, String deviceId) throws IoTDBConnectionException, StatementExecutionException {
        ArrayList<MeasurementSchema> schemaList = new ArrayList<MeasurementSchema>();
        schemaList.add(new MeasurementSchema("s1", TSDataType.INT64));
        schemaList.add(new MeasurementSchema("s2", TSDataType.INT64));
        schemaList.add(new MeasurementSchema("s3", TSDataType.INT64));
        Tablet tablet = new Tablet(deviceId, schemaList, 100);
        long timestamp = System.currentTimeMillis();
        for (long row = 0L; row < 100L; ++row) {
            int rowIndex = tablet.getRowSize();
            tablet.addTimestamp(rowIndex, timestamp);
            for (int s = 0; s < 3; ++s) {
                long value = random.nextLong();
                tablet.addValue(((IMeasurementSchema)schemaList.get(s)).getMeasurementName(), rowIndex, (Object)value);
            }
            if (tablet.getRowSize() == tablet.getMaxRowNumber()) {
                session.insertTablet(tablet, true);
                tablet.reset();
            }
            ++timestamp;
        }
        if (tablet.getRowSize() != 0) {
            session.insertTablet(tablet);
            tablet.reset();
        }
    }
}

