/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb;

import java.util.ArrayList;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HybridTimeseriesSessionExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(HybridTimeseriesSessionExample.class);
    private static Session session;
    private static final String ROOT_SG1_ALIGNEDDEVICE = "root.sg_1.aligned_device";
    private static final String ROOT_SG1_D1 = "root.sg_1.d1";
    private static final String ROOT_SG1_D2 = "root.sg_1.d2";

    public static void main(String[] args) throws IoTDBConnectionException, StatementExecutionException {
        session = new Session("127.0.0.1", 6667, "root", "root");
        session.open(false);
        session.setFetchSize(10000);
        HybridTimeseriesSessionExample.insertRecord(ROOT_SG1_D2, 0, 100);
        HybridTimeseriesSessionExample.insertTabletWithAlignedTimeseriesMethod(0, 100);
        HybridTimeseriesSessionExample.insertRecord(ROOT_SG1_D1, 0, 100);
        session.executeNonQueryStatement("flush");
        HybridTimeseriesSessionExample.selectTest();
        session.close();
    }

    private static void selectTest() throws StatementExecutionException, IoTDBConnectionException {
        SessionDataSet dataSet = session.executeQueryStatement("select ** from root.sg_1");
        LOGGER.info("columnNames = {}", (Object)dataSet.getColumnNames());
        while (dataSet.hasNext()) {
            LOGGER.info("data = {}", (Object)dataSet.next());
        }
        dataSet.closeOperationHandle();
    }

    private static void insertTabletWithAlignedTimeseriesMethod(int minTime, int maxTime) throws IoTDBConnectionException, StatementExecutionException {
        ArrayList<MeasurementSchema> schemaList = new ArrayList<MeasurementSchema>();
        schemaList.add(new MeasurementSchema("s1", TSDataType.INT64));
        schemaList.add(new MeasurementSchema("s2", TSDataType.INT32));
        Tablet tablet = new Tablet(ROOT_SG1_ALIGNEDDEVICE, schemaList);
        long timestamp = minTime;
        for (long row = (long)minTime; row < (long)maxTime; ++row) {
            int rowIndex;
            ++tablet.rowSize;
            tablet.addTimestamp(rowIndex, timestamp);
            tablet.addValue(((MeasurementSchema)schemaList.get(0)).getMeasurementId(), rowIndex, (Object)(row * 10L + 1L));
            tablet.addValue(((MeasurementSchema)schemaList.get(1)).getMeasurementId(), rowIndex, (Object)((int)(row * 10L + 2L)));
            if (tablet.rowSize == tablet.getMaxRowNumber()) {
                session.insertAlignedTablet(tablet, true);
                tablet.reset();
            }
            ++timestamp;
        }
        if (tablet.rowSize != 0) {
            session.insertAlignedTablet(tablet);
            tablet.reset();
        }
    }

    private static void insertRecord(String deviceId, int minTime, int maxTime) throws IoTDBConnectionException, StatementExecutionException {
        ArrayList<String> measurements = new ArrayList<String>();
        ArrayList<TSDataType> types = new ArrayList<TSDataType>();
        measurements.add("s2");
        measurements.add("s4");
        measurements.add("s5");
        measurements.add("s6");
        types.add(TSDataType.INT64);
        types.add(TSDataType.INT64);
        types.add(TSDataType.INT64);
        types.add(TSDataType.INT64);
        for (long time = (long)minTime; time < (long)maxTime; ++time) {
            ArrayList<Long> values = new ArrayList<Long>();
            values.add(time * 10L + 3L);
            values.add(time * 10L + 4L);
            values.add(time * 10L + 5L);
            values.add(time * 10L + 6L);
            session.insertRecord(deviceId, time, measurements, types, values);
        }
    }
}

