/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.parser;

import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jsqlparser.expression.IntervalExpression;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.TransformParser;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.apache.inlong.sdk.transform.process.utils.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformParser(values={IntervalExpression.class})
public class IntervalParser
implements ValueParser {
    private static final Logger log = LoggerFactory.getLogger(IntervalParser.class);
    private final String intervalType;
    private final ValueParser dateParser;
    private final String parameter;
    private static final Map<String, DateTimeFormatter> DT_FORMATTER_MAP = new ConcurrentHashMap<String, DateTimeFormatter>();

    public IntervalParser(IntervalExpression expr) {
        this.intervalType = expr.getIntervalType().toUpperCase();
        this.dateParser = OperatorTools.buildParser(expr.getExpression());
        this.parameter = this.dateParser == null ? expr.getParameter() : null;
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        DateTimeFormatter dateTimeFormatter = DT_FORMATTER_MAP.get(this.intervalType);
        String dateStr = this.parameter;
        if (this.dateParser != null) {
            Object dateObj = this.dateParser.parse(sourceData, rowIndex, context);
            if (dateObj == null) {
                return null;
            }
            dateStr = OperatorTools.parseString(dateObj);
        }
        int factor = 1;
        if (dateTimeFormatter == null) {
            if ("WEEK".equals(this.intervalType)) {
                dateTimeFormatter = DT_FORMATTER_MAP.get("DAY");
                factor = 7;
            } else if ("QUARTER".equals(this.intervalType)) {
                dateTimeFormatter = DT_FORMATTER_MAP.get("MONTH");
                factor = 3;
            } else {
                return null;
            }
        }
        try {
            int n = factor = dateStr.charAt(0) == '-' ? -factor : factor;
            if (factor < 0) {
                dateStr = dateStr.substring(1);
            }
            return DateUtil.parseIntervalInfo(dateTimeFormatter, dateStr, factor);
        }
        catch (Exception e) {
            log.error("Interval parse error", (Throwable)e);
            return null;
        }
    }

    static {
        DT_FORMATTER_MAP.put("SECOND_MICROSECOND", DateTimeFormatter.ofPattern("s.SSSSSS"));
        DT_FORMATTER_MAP.put("MINUTE_MICROSECOND", DateTimeFormatter.ofPattern("m:s.SSSSSS"));
        DT_FORMATTER_MAP.put("MINUTE_SECOND", DateTimeFormatter.ofPattern("m:s"));
        DT_FORMATTER_MAP.put("HOUR_MICROSECOND", DateTimeFormatter.ofPattern("H:m:s.SSSSSS"));
        DT_FORMATTER_MAP.put("HOUR_SECOND", DateTimeFormatter.ofPattern("H:m:s"));
        DT_FORMATTER_MAP.put("HOUR_MINUTE", DateTimeFormatter.ofPattern("H:m"));
        DT_FORMATTER_MAP.put("DAY_MICROSECOND", DateTimeFormatter.ofPattern("d H:m:s.SSSSSS"));
        DT_FORMATTER_MAP.put("DAY_SECOND", DateTimeFormatter.ofPattern("d H:m:s"));
        DT_FORMATTER_MAP.put("DAY_MINUTE", DateTimeFormatter.ofPattern("d H:m"));
        DT_FORMATTER_MAP.put("DAY_HOUR", DateTimeFormatter.ofPattern("d H"));
        DT_FORMATTER_MAP.put("YEAR_MONTH", DateTimeFormatter.ofPattern("y-M"));
        DT_FORMATTER_MAP.put("MICROSECOND", DateTimeFormatter.ofPattern("SSSSSS"));
        DT_FORMATTER_MAP.put("SECOND", DateTimeFormatter.ofPattern("s"));
        DT_FORMATTER_MAP.put("MINUTE", DateTimeFormatter.ofPattern("m"));
        DT_FORMATTER_MAP.put("HOUR", DateTimeFormatter.ofPattern("H"));
        DT_FORMATTER_MAP.put("DAY", DateTimeFormatter.ofPattern("d"));
        DT_FORMATTER_MAP.put("MONTH", DateTimeFormatter.ofPattern("M"));
        DT_FORMATTER_MAP.put("YEAR", DateTimeFormatter.ofPattern("y"));
    }
}

