/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.temporal;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="temporal", names={"to_date"}, parameter="(String str [,String format])", descriptions={"- Return \"\" if 'str' is NULL;", "- Return the result of converting the date string 'str' to a date in the format 'format'(default is 'yyyy-MM-dd')."}, examples={"to_date('20240815', 'yyyyMMdd') = \"2024-08-15\""})
public class ToDateFunction
implements ValueParser {
    private ValueParser stringParser1;
    private ValueParser stringParser2;
    private static final Map<String, DateTimeFormatter> INPUT_FORMATTERS = new ConcurrentHashMap<String, DateTimeFormatter>();
    private static final DateTimeFormatter OUTPUT_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public ToDateFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.stringParser1 = OperatorTools.buildParser((Expression)expressions.get(0));
        if (expressions.size() == 2) {
            this.stringParser2 = OperatorTools.buildParser((Expression)expressions.get(1));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object stringObj1 = this.stringParser1.parse(sourceData, rowIndex, context);
        String str1 = OperatorTools.parseString(stringObj1);
        String str2 = "yyyy-MM-dd";
        if (this.stringParser2 != null) {
            Object stringObj2 = this.stringParser2.parse(sourceData, rowIndex, context);
            str2 = OperatorTools.parseString(stringObj2);
        }
        LocalDate date = LocalDate.parse(str1, this.getDateTimeFormatter(str2));
        return date.format(OUTPUT_FORMATTER);
    }

    private DateTimeFormatter getDateTimeFormatter(String pattern) {
        DateTimeFormatter formatter = INPUT_FORMATTERS.get(pattern);
        if (formatter == null) {
            formatter = DateTimeFormatter.ofPattern(pattern);
            INPUT_FORMATTERS.put(pattern, formatter);
        }
        return formatter;
    }
}

