/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.temporal;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.apache.inlong.sdk.transform.process.utils.DateUtil;

@TransformFunction(type="temporal", names={"timestamp"}, parameter="(String unit, String datetime_expr1, String datetime_expr2)", descriptions={"- Return \"\" if 'datetime_expr1' or 'datetime_expr2' is NULL;", "- Return the date or datetime expression expr as a datetime value if there is only one parameter;", "- Return the result of the date or date time expression 'datetime_expr1' plus the time expression 'datetime_expr2' if there are two parameters."}, examples={"timestamp('2003-12-31 12:00:00.600000','12:00:00') = \"2004-01-01 00:00:00.600000\""})
public class TimestampFunction
implements ValueParser {
    private ValueParser dateTimeExprParser;
    private ValueParser timeExprParser;

    public TimestampFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.dateTimeExprParser = OperatorTools.buildParser((Expression)expressions.get(0));
        if (expressions.size() == 2) {
            this.timeExprParser = OperatorTools.buildParser((Expression)expressions.get(1));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object dateTimeExprObj = this.dateTimeExprParser.parse(sourceData, rowIndex, context);
        if (dateTimeExprObj == null) {
            return null;
        }
        String dateTimeStr = dateTimeExprObj.toString();
        LocalDateTime localDateTime = DateUtil.parseLocalDateTime(dateTimeExprObj.toString());
        if (localDateTime == null) {
            return null;
        }
        boolean hasMicroSecond = dateTimeStr.indexOf(46) != -1;
        String formatStr = DateUtil.YEAR_TO_SECOND;
        if (this.timeExprParser != null) {
            Object timeExprObj = this.timeExprParser.parse(sourceData, rowIndex, context);
            if (timeExprObj != null) {
                String timeStr = timeExprObj.toString();
                LocalTime localTime = DateUtil.parseLocalTime(timeStr);
                if (localTime == null) {
                    return null;
                }
                hasMicroSecond |= timeStr.indexOf(46) != -1;
                localDateTime = DateUtil.dateAdd(localDateTime, localTime);
            } else {
                return null;
            }
        }
        if (hasMicroSecond) {
            formatStr = DateUtil.YEAR_TO_MICRO;
        }
        return localDateTime.format(DateUtil.getDateTimeFormatter(formatStr));
    }
}

