/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.temporal;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.apache.inlong.sdk.transform.process.pojo.IntervalInfo;
import org.apache.inlong.sdk.transform.process.utils.DateUtil;

@TransformFunction(type="temporal", names={"date_sub", "datesub"}, parameter="(String dateStr,String intervalExprStr)", descriptions={"- Return \"\" if 'dateStr' is NULL;", "- Return DATE if the date argument is a DATE value and your calculations involve only YEAR, MONTH, and DAY parts(that is, no time parts);", "- Return TIME if the date argument is a TIME value and the calculations involve only HOURS, MINUTES,and SECONDS parts (that is, no date parts);", "- Return DATETIME if the first argument is a DATETIME (or TIMESTAMP) value, or if the first argument is a DATE and the unit value uses HOURS, MINUTES, or SECONDS, or if the first argument is of type TIME and the unit value uses YEAR, MONTH, or DAY;", "- Return String otherwise (type VARCHAR).", "Note: Regarding 'intervalExpr', please refer to the MySQL official website."}, examples={"DATE_SUB('1992-12-31 23:59:59', INTERVAL '-1.999999' SECOND_MICROSECOND) = \"1993-01-01 00:00:00.999999\""})
public class DateSubFunction
implements ValueParser {
    private final ValueParser datetimeParser;
    private final ValueParser intervalParser;

    public DateSubFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.datetimeParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.intervalParser = OperatorTools.buildParser((Expression)expressions.get(1));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object intervalInfoObj = this.intervalParser.parse(sourceData, rowIndex, context);
        Object dateObj = this.datetimeParser.parse(sourceData, rowIndex, context);
        if (intervalInfoObj == null || dateObj == null) {
            return null;
        }
        return DateUtil.dateTypeAdd(OperatorTools.parseString(dateObj), (IntervalInfo)intervalInfoObj, false);
    }
}

