/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"right"}, parameter="(String str)", descriptions={"- Return \"\" if either 'str' or 'len' is NULL;", "- Return \"\" if it is less than or equal to zero;", "- Return a substring of 'len' starting from the right side of the 'str'."}, examples={"right('hello world',100) = \"hello world\""})
public class RightFunction
implements ValueParser {
    private final ValueParser stringParser;
    private final ValueParser lengthParser;

    public RightFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.stringParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.lengthParser = OperatorTools.buildParser((Expression)expressions.get(1));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object stringObj = this.stringParser.parse(sourceData, rowIndex, context);
        Object lengthObj = this.lengthParser.parse(sourceData, rowIndex, context);
        if (stringObj == null || lengthObj == null) {
            return null;
        }
        String str = OperatorTools.parseString(stringObj);
        int len = Integer.parseInt(OperatorTools.parseString(lengthObj));
        if (len <= 0) {
            return "";
        }
        return str.substring(Math.max(str.length() - len, 0));
    }
}

