/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.collection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="collection", names={"map_union"}, parameter="([Map map1, Map map2, ...])", descriptions={"- Return \"\" if any of maps is null;", "- Return a map created by merging at least one map.These maps should have a common map type, the following map will overwrite the previous one."}, examples={"map_union(map('he', 1),map('xxd', 3)) = {he=1, xxd=3}", "map_union(map('he', 1),map('he', 3)) = {he=3}"})
public class MapUnionFunction
implements ValueParser {
    private List<ValueParser> parserList;

    public MapUnionFunction(Function expr) {
        if (expr.getParameters() == null) {
            this.parserList = new ArrayList<ValueParser>();
        } else {
            List params = expr.getParameters().getExpressions();
            this.parserList = new ArrayList<ValueParser>(params.size());
            for (Expression param : params) {
                ValueParser node = OperatorTools.buildParser(param);
                this.parserList.add(node);
            }
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        HashMap res = new HashMap();
        for (ValueParser valueParser : this.parserList) {
            Object mapObj = valueParser.parse(sourceData, rowIndex, context);
            if (mapObj == null) {
                return null;
            }
            if (!(mapObj instanceof Map)) continue;
            Map map = (Map)mapObj;
            if (map.isEmpty()) {
                return null;
            }
            res.putAll(map);
        }
        return res;
    }
}

