/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.collection;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformFunction(type="collection", names={"map_from_arrays"}, parameter="(Array array_of_keys, Array array_of_values)", descriptions={"- Return \"\" if any parameter is NULL;", "- Return a map created from an arrays of keys and values."}, examples={"map_from_arrays(array('he', 'xxd'),array(1, 3)) = {he=1, xxd=3}", "map_from_arrays(array('xxd', array('cloud')),array(1, array(2))) = {1=xxd, [2]=[cloud]}"})
public class MapFromArraysFunction
implements ValueParser {
    private static final Logger log = LoggerFactory.getLogger(MapFromArraysFunction.class);
    private ValueParser keyArrayParser;
    private ValueParser valueArrayParser;

    public MapFromArraysFunction(Function expr) {
        if (expr.getParameters().getExpressions().size() >= 2) {
            this.keyArrayParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
            this.valueArrayParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(1));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object keyArrayObj = this.keyArrayParser.parse(sourceData, rowIndex, context);
        Object valueArrayObj = this.valueArrayParser.parse(sourceData, rowIndex, context);
        if (keyArrayObj == null || valueArrayObj == null) {
            return null;
        }
        if (keyArrayObj instanceof ArrayList && valueArrayObj instanceof ArrayList) {
            ArrayList keyArray = (ArrayList)keyArrayObj;
            ArrayList valueArray = (ArrayList)valueArrayObj;
            if (keyArray.size() != valueArray.size()) {
                log.warn("The lengths of the keys and values arrays must be the same.");
                return null;
            }
            LinkedHashMap res = new LinkedHashMap();
            for (int i = 0; i < keyArray.size(); ++i) {
                res.put(keyArray.get(i), valueArray.get(i));
            }
            return res;
        }
        return null;
    }
}

