/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.collection;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="collection", names={"array_distinct"}, parameter="(Array array)", descriptions={"- Return \"\" if 'array' is NULL;", "- Return an array with unique elements."}, examples={"array_distinct(array('he',-1,'he')) = [he, -1]"})
public class ArrayDistinctFunction
implements ValueParser {
    private final ValueParser arrayParser;

    public ArrayDistinctFunction(Function expr) {
        this.arrayParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object arrayObj = this.arrayParser.parse(sourceData, rowIndex, context);
        if (arrayObj == null) {
            return null;
        }
        if (arrayObj instanceof ArrayList) {
            ArrayList array = (ArrayList)arrayObj;
            if (array.isEmpty()) {
                return null;
            }
            LinkedHashSet distinctSet = new LinkedHashSet(array);
            return new ArrayList(distinctSet);
        }
        return null;
    }
}

