/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.arithmetic;

import java.math.BigInteger;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="arithmetic", names={"radix_convert"}, parameter="(Numeric numeric)", descriptions={"- Return \"\" if any of its arguments are NULL;", "- Return the result of converting 'numeric' from 'from_base' to 'to_base'.", "Note: abs(base) between [2,36].'from_base' is a negative number, 'numeric' is regarded as a signed number. Otherwise, 'numeric' is treated as unsigned. This function works with 64-bit precision."}, examples={"radix_convert('6E',18,8) = 172"})
public class RadixConvertFunction
implements ValueParser {
    private final ValueParser numParser;
    private final ValueParser fromBaseParser;
    private final ValueParser toBaseParser;

    public RadixConvertFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.numParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.fromBaseParser = OperatorTools.buildParser((Expression)expressions.get(1));
        this.toBaseParser = OperatorTools.buildParser((Expression)expressions.get(2));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object numObj = this.numParser.parse(sourceData, rowIndex, context);
        Object fromBaseObj = this.fromBaseParser.parse(sourceData, rowIndex, context);
        Object toBaseObj = this.toBaseParser.parse(sourceData, rowIndex, context);
        if (numObj == null || fromBaseObj == null || toBaseObj == null) {
            return null;
        }
        String num = OperatorTools.parseString(numObj);
        int fromBase = Integer.parseInt(fromBaseObj.toString());
        int toBase = Integer.parseInt(toBaseObj.toString());
        return RadixConvertFunction.conv(num, fromBase, toBase);
    }

    public static String conv(String number, int fromBase, int toBase) {
        if (!RadixConvertFunction.checkRange(fromBase) || !RadixConvertFunction.checkRange(toBase)) {
            return null;
        }
        try {
            BigInteger num = new BigInteger(number, Math.abs(fromBase));
            if (fromBase > 0) {
                return num.toString(Math.abs(toBase)).toUpperCase();
            }
            return new BigInteger(Long.toUnsignedString(num.longValue()), 10).toString(Math.abs(toBase)).toUpperCase();
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static boolean checkRange(int base) {
        return Math.abs(base) >= 2 && Math.abs(base) <= 36;
    }
}

