/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.arithmetic;

import java.math.BigDecimal;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="arithmetic", names={"mod"}, parameter="(Numeric numeric1, Numeric numeric2)", descriptions={"- Return \"\" if any parameter is null;", "- Return the remainder of 'numeric1' divided by 'numeric2'."}, examples={"mod(3,2) = 1", "mod(-3.1415926,100) = -3.1415926"})
public class ModuloFunction
implements ValueParser {
    private ValueParser dividendParser;
    private ValueParser divisorParser;

    public ModuloFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.dividendParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.divisorParser = OperatorTools.buildParser((Expression)expressions.get(1));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object dividendObj = this.dividendParser.parse(sourceData, rowIndex, context);
        Object divisorObj = this.divisorParser.parse(sourceData, rowIndex, context);
        if (divisorObj == null || dividendObj == null) {
            return null;
        }
        BigDecimal dividend = OperatorTools.parseBigDecimal(dividendObj);
        BigDecimal divisor = OperatorTools.parseBigDecimal(divisorObj);
        return dividend.remainder(divisor);
    }
}

