/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.arithmetic;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="arithmetic", names={"lcm"}, parameter="(Numeric numeric1,Numeric numeric2)", descriptions={"- Return \"\" if any parameter is NULL;", "- Return 0 if either input is zero;", "- Return least common multiple (the smallest strictly positive number that is an integral multiple of both inputs)."}, examples={"lcm(6,3) = 6", "lcm(3.141,3.846) = 4026.762"})
public class LcmFunction
implements ValueParser {
    private final ValueParser firstNumParser;
    private final ValueParser secondNumTypeParser;

    public LcmFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.firstNumParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.secondNumTypeParser = OperatorTools.buildParser((Expression)expressions.get(1));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object firstNumObj = this.firstNumParser.parse(sourceData, rowIndex, context);
        Object secondNumObj = this.secondNumTypeParser.parse(sourceData, rowIndex, context);
        if (firstNumObj == null || secondNumObj == null) {
            return null;
        }
        BigDecimal firstNum = OperatorTools.parseBigDecimal(firstNumObj);
        BigDecimal secondNum = OperatorTools.parseBigDecimal(secondNumObj);
        return LcmFunction.lcm(firstNum, secondNum).toPlainString();
    }

    public static BigInteger gcd(BigDecimal a, BigDecimal b) {
        BigInteger intA = a.toBigInteger();
        BigInteger intB = b.toBigInteger();
        return intA.gcd(intB);
    }

    public static BigDecimal lcm(BigDecimal a, BigDecimal b) {
        if (a.compareTo(BigDecimal.ZERO) == 0 || b.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        int maxScale = Math.max(a.scale(), b.scale());
        BigDecimal factorA = a.movePointRight(maxScale);
        BigDecimal factorB = b.movePointRight(maxScale);
        BigInteger gcdValue = LcmFunction.gcd(factorA, factorB);
        BigDecimal product = factorA.multiply(factorB);
        BigDecimal lcmValue = product.divide(new BigDecimal(gcdValue), RoundingMode.HALF_UP);
        return lcmValue.movePointLeft(maxScale).stripTrailingZeros();
    }
}

