/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.arithmetic;

import java.math.BigDecimal;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="arithmetic", names={"atan2"}, parameter="(Numeric numeric)", descriptions={"Return \"\" if 'numericx' or 'numericy' is NULL;", "Return the arc tangent of a coordinate ('numericx', 'numericy')."}, examples={"atan2(1, 1) = 0.7853981633974483", "atan2(1, 0) = 1.5707963267948966", "atan2(0, -1) = 3.141592653589793"})
public class Atan2Function
implements ValueParser {
    private ValueParser xParser;
    private ValueParser yParser;

    public Atan2Function(Function expr) {
        this.xParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
        this.yParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(1));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object xObj = this.xParser.parse(sourceData, rowIndex, context);
        Object yObj = this.yParser.parse(sourceData, rowIndex, context);
        if (xObj == null || yObj == null) {
            return null;
        }
        BigDecimal xValue = OperatorTools.parseBigDecimal(xObj);
        BigDecimal yValue = OperatorTools.parseBigDecimal(yObj);
        return Math.atan2(xValue.doubleValue(), yValue.doubleValue());
    }
}

