/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.decode;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SplitUtils {
    public static final int STATE_NORMAL = 0;
    public static final int STATE_KEY = 2;
    public static final int STATE_VALUE = 4;
    public static final int STATE_ESCAPING = 8;
    public static final int STATE_QUOTING = 16;

    public static String[] splitCsv(@Nonnull String text, @Nonnull Character delimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, boolean hasEscapeProcess) {
        String[][] splitResult = SplitUtils.splitCsv(text, delimiter, escapeChar, quoteChar, null, hasEscapeProcess);
        if (splitResult.length == 0) {
            return new String[0];
        }
        return splitResult[0];
    }

    public static String[][] splitCsv(@Nonnull String text, @Nonnull Character delimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nullable Character lineDelimiter, boolean hasEscapeProcess) {
        return SplitUtils.splitCsv(text, delimiter, escapeChar, quoteChar, lineDelimiter, false, hasEscapeProcess);
    }

    public static String[][] splitCsv(@Nonnull String text, @Nonnull Character delimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nullable Character lineDelimiter, boolean deleteHeadDelimiter, boolean hasEscapeProcess) {
        char deli = delimiter.charValue();
        char escape = escapeChar == null ? (char)'\\' : (char)escapeChar.charValue();
        char quote = quoteChar == null ? (char)'\"' : (char)quoteChar.charValue();
        char line = lineDelimiter == null ? (char)'\n' : (char)lineDelimiter.charValue();
        ArrayList<String[]> lines = new ArrayList<String[]>();
        ArrayList<String> fields = new ArrayList<String>();
        int state = 0;
        char[] srcValue = text.toCharArray();
        char[] fieldValue = new char[srcValue.length];
        int fieldIndex = 0;
        for (int i = 0; i < text.length(); ++i) {
            char ch = srcValue[i];
            if (ch == deli) {
                switch (state) {
                    case 0: {
                        if (fieldIndex == 0 && deleteHeadDelimiter && fields.isEmpty()) break;
                        fields.add(new String(fieldValue, 0, fieldIndex));
                        fieldIndex = 0;
                        break;
                    }
                    case 8: {
                        fieldValue[fieldIndex++] = ch;
                        state = 0;
                        break;
                    }
                    case 16: {
                        fieldValue[fieldIndex++] = ch;
                        break;
                    }
                }
                continue;
            }
            if (escapeChar != null && ch == escape) {
                switch (state) {
                    case 0: {
                        state = 8;
                        break;
                    }
                    case 8: {
                        if (!hasEscapeProcess) {
                            fieldValue[fieldIndex++] = escapeChar.charValue();
                        }
                        fieldValue[fieldIndex++] = ch;
                        state = 0;
                        break;
                    }
                    case 16: {
                        fieldValue[fieldIndex++] = ch;
                        break;
                    }
                }
                continue;
            }
            if (quoteChar != null && ch == quote) {
                switch (state) {
                    case 0: {
                        state = 16;
                        break;
                    }
                    case 8: {
                        if (!hasEscapeProcess) {
                            fieldValue[fieldIndex++] = escapeChar.charValue();
                        }
                        fieldValue[fieldIndex++] = ch;
                        state = 0;
                        break;
                    }
                    case 16: {
                        state = 0;
                        break;
                    }
                }
                continue;
            }
            if (lineDelimiter != null && ch == line) {
                switch (state) {
                    case 0: {
                        fields.add(new String(fieldValue, 0, fieldIndex));
                        fieldIndex = 0;
                        lines.add(fields.toArray(new String[0]));
                        fields.clear();
                        break;
                    }
                    case 8: {
                        fieldValue[fieldIndex++] = ch;
                        state = 0;
                        break;
                    }
                    case 16: {
                        fieldValue[fieldIndex++] = ch;
                        break;
                    }
                }
                continue;
            }
            if (state == 8) {
                if (!hasEscapeProcess) {
                    fieldValue[fieldIndex++] = escapeChar.charValue();
                }
                state = 0;
            }
            fieldValue[fieldIndex++] = ch;
        }
        fields.add(new String(fieldValue, 0, fieldIndex));
        fieldIndex = 0;
        lines.add(fields.toArray(new String[0]));
        String[][] result = new String[lines.size()][];
        for (int i = 0; i < lines.size(); ++i) {
            result[i] = (String[])lines.get(i);
        }
        return result;
    }
}

