/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.core.impl;

import java.util.List;
import org.apache.inlong.manager.pojo.workflow.form.task.TaskForm;
import org.apache.inlong.manager.workflow.WorkflowAction;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.core.ProcessorExecutor;
import org.apache.inlong.manager.workflow.core.TaskService;
import org.apache.inlong.manager.workflow.core.WorkflowContextBuilder;
import org.apache.inlong.manager.workflow.definition.ServiceTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskServiceImpl
implements TaskService {
    @Autowired
    private ProcessorExecutor processorExecutor;
    @Autowired
    private WorkflowContextBuilder workflowContextBuilder;

    @Override
    public WorkflowContext approve(Integer taskId, String remark, TaskForm form, String operator) {
        WorkflowContext context = this.workflowContextBuilder.buildContextForTask(taskId, WorkflowAction.APPROVE, form, remark, operator);
        this.processorExecutor.executeComplete(context.getActionContext().getTask(), context);
        return context;
    }

    @Override
    public WorkflowContext reject(Integer taskId, String remark, String operator) {
        WorkflowContext context = this.workflowContextBuilder.buildContextForTask(taskId, WorkflowAction.REJECT, remark, operator);
        this.processorExecutor.executeComplete(context.getActionContext().getTask(), context);
        return context;
    }

    @Override
    public WorkflowContext transfer(Integer taskId, String remark, List<String> to, String operator) {
        WorkflowContext context = this.workflowContextBuilder.buildContextForTask(taskId, WorkflowAction.TRANSFER, to, remark, operator);
        this.processorExecutor.executeComplete(context.getActionContext().getTask(), context);
        return context;
    }

    @Override
    public WorkflowContext complete(Integer taskId, String remark, String operator) {
        WorkflowContext context = this.workflowContextBuilder.buildContextForTask(taskId, WorkflowAction.COMPLETE, remark, operator);
        ServiceTask serviceTask = (ServiceTask)context.getActionContext().getTask();
        serviceTask.initListeners(context);
        this.processorExecutor.executeComplete(context.getActionContext().getTask(), context);
        return context;
    }
}

