/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.stream;

import org.apache.inlong.manager.common.enums.ProcessName;
import org.apache.inlong.manager.pojo.workflow.form.process.StreamResourceProcessForm;
import org.apache.inlong.manager.service.listener.StreamTaskListenerFactory;
import org.apache.inlong.manager.service.listener.stream.UpdateStreamCompleteListener;
import org.apache.inlong.manager.service.listener.stream.UpdateStreamFailedListener;
import org.apache.inlong.manager.service.listener.stream.UpdateStreamListener;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.definition.EndEvent;
import org.apache.inlong.manager.workflow.definition.ServiceTask;
import org.apache.inlong.manager.workflow.definition.ServiceTaskType;
import org.apache.inlong.manager.workflow.definition.StartEvent;
import org.apache.inlong.manager.workflow.definition.TaskListenerFactory;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SuspendStreamWorkflowDefinition
implements WorkflowDefinition {
    private static final Logger log = LoggerFactory.getLogger(SuspendStreamWorkflowDefinition.class);
    @Autowired
    private UpdateStreamListener updateStreamListener;
    @Autowired
    private UpdateStreamCompleteListener updateStreamCompleteListener;
    @Autowired
    private UpdateStreamFailedListener updateStreamFailedListener;
    @Autowired
    private StreamTaskListenerFactory streamTaskListenerFactory;

    @Override
    public WorkflowProcess defineProcess() {
        WorkflowProcess process = new WorkflowProcess();
        process.setName(this.getProcessName().name());
        process.setType(this.getProcessName().getDisplayName());
        process.setDisplayName(this.getProcessName().getDisplayName());
        process.setFormClass(StreamResourceProcessForm.class);
        process.setVersion(1);
        process.setHidden(Integer.valueOf(1));
        process.addListener((ProcessEventListener)this.updateStreamListener);
        process.addListener((ProcessEventListener)this.updateStreamFailedListener);
        process.addListener((ProcessEventListener)this.updateStreamCompleteListener);
        StartEvent startEvent = new StartEvent();
        process.setStartEvent(startEvent);
        ServiceTask stopDataSourceTask = new ServiceTask();
        stopDataSourceTask.setName("StopSource");
        stopDataSourceTask.setDisplayName("Stream-StopSource");
        stopDataSourceTask.setServiceTaskType(ServiceTaskType.STOP_SOURCE);
        stopDataSourceTask.setListenerFactory((TaskListenerFactory)this.streamTaskListenerFactory);
        process.addTask((WorkflowTask)stopDataSourceTask);
        ServiceTask stopSortTask = new ServiceTask();
        stopSortTask.setName("StopSort");
        stopSortTask.setDisplayName("Stream-StopSort");
        stopSortTask.setServiceTaskType(ServiceTaskType.STOP_SORT);
        stopSortTask.setListenerFactory((TaskListenerFactory)this.streamTaskListenerFactory);
        process.addTask((WorkflowTask)stopSortTask);
        EndEvent endEvent = new EndEvent();
        process.setEndEvent(endEvent);
        startEvent.addNext((Element)stopDataSourceTask);
        stopDataSourceTask.addNext((Element)stopSortTask);
        stopSortTask.addNext((Element)endEvent);
        return process;
    }

    @Override
    public ProcessName getProcessName() {
        return ProcessName.SUSPEND_STREAM_RESOURCE;
    }
}

