/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.hive;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.pojo.sink.hive.HiveColumnInfo;
import org.apache.inlong.manager.pojo.sink.hive.HiveTableInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlBuilder.class);

    public static String buildCreateDbSql(String dbName) {
        String sql = "CREATE DATABASE IF NOT EXISTS `" + dbName + "`";
        LOGGER.info("create db sql: {}", (Object)sql);
        return sql;
    }

    public static String buildCreateTableSql(HiveTableInfo table) {
        StringBuilder sql = new StringBuilder();
        String dbTableName = "`" + table.getDbName() + "." + table.getTableName() + "`";
        sql.append("CREATE TABLE ").append(dbTableName);
        sql.append(SqlBuilder.getColumnsAndComments(table.getColumns(), table.getTableDesc()));
        if (table.getFieldTerSymbol() != null) {
            sql.append(" ROW FORMAT DELIMITED FIELDS TERMINATED BY '").append(table.getFieldTerSymbol()).append("'");
        }
        LOGGER.info("create table sql: {}", (Object)sql);
        return sql.toString();
    }

    public static String buildDescTableSql(String dbName, String tableName) {
        StringBuilder sql = new StringBuilder();
        String fullTableName = "`" + dbName + "." + tableName + "`";
        sql.append("DESC ").append(fullTableName);
        LOGGER.info("desc table sql={}", (Object)sql);
        return sql.toString();
    }

    public static String buildAddColumnSql(String dbName, String tableName, List<HiveColumnInfo> columnList) {
        StringBuilder sql = new StringBuilder();
        String dbTableName = "`" + dbName + "." + tableName + "`";
        sql.append("ALTER TABLE ").append(dbTableName);
        ArrayList<String> columnInfoList = new ArrayList<String>();
        for (HiveColumnInfo columnInfo : columnList) {
            if (columnInfo.isPartition()) continue;
            StringBuilder columnStr = new StringBuilder().append("`").append(columnInfo.getName()).append("` ").append(columnInfo.getType());
            if (StringUtils.isNotEmpty((CharSequence)columnInfo.getDesc())) {
                columnStr.append(" COMMENT ").append("'").append(columnInfo.getDesc()).append("'");
            }
            columnInfoList.add(columnStr.toString());
        }
        sql.append(" ADD COLUMNS (").append(StringUtils.join(columnInfoList, (String)",")).append(") ");
        LOGGER.info("add columns sql={}", (Object)sql);
        return sql.toString();
    }

    private static String getColumnsAndComments(List<HiveColumnInfo> columns, String tableComment) {
        ArrayList<String> columnList = new ArrayList<String>();
        ArrayList<String> partitionList = new ArrayList<String>();
        for (HiveColumnInfo columnInfo : columns) {
            StringBuilder columnStr = new StringBuilder().append("`").append(columnInfo.getName()).append("` ").append(columnInfo.getType());
            if (StringUtils.isNotEmpty((CharSequence)columnInfo.getDesc())) {
                columnStr.append(" COMMENT ").append("'").append(columnInfo.getDesc()).append("'");
            }
            if (columnInfo.isPartition()) {
                partitionList.add(columnStr.toString());
                continue;
            }
            columnList.add(columnStr.toString());
        }
        StringBuilder result = new StringBuilder().append(" (").append(StringUtils.join(columnList, (String)",")).append(") ");
        if (StringUtils.isNotEmpty((CharSequence)tableComment)) {
            result.append("COMMENT ").append("'").append(tableComment).append("' ");
        }
        if (partitionList.size() > 0) {
            result.append("PARTITIONED BY (").append(StringUtils.join(partitionList, (String)",")).append(") ");
        }
        return result.toString();
    }
}

